/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.ActionLogEntry;
import com.megacrit.cardcrawl.actions.common.DrawCardAction;
import com.megacrit.cardcrawl.actions.common.EnableEndTurnButtonAction;
import com.megacrit.cardcrawl.actions.common.HealAction;
import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardQueueItem;
import com.megacrit.cardcrawl.cards.colorless.Shiv;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.ThoughtBubble;
import com.megacrit.cardcrawl.vfx.cardManip.ExhaustCardEffect;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameActionManager {
    private static final Logger logger = LogManager.getLogger(GameActionManager.class.getName());
    private ArrayList<AbstractGameAction> nextCombatActions = new ArrayList();
    public ArrayList<AbstractGameAction> actions = new ArrayList();
    public ArrayList<AbstractGameAction> preTurnActions = new ArrayList();
    public ArrayList<CardQueueItem> cardQueue = new ArrayList();
    public ArrayList<AbstractCard> cardsPlayedThisTurn = new ArrayList();
    public ArrayList<AbstractCard> cardsPlayedThisCombat = new ArrayList();
    public AbstractGameAction currentAction;
    public AbstractGameAction previousAction;
    public AbstractGameAction turnStartCurrentAction;
    public AbstractCard lastCard = null;
    public Phase phase = Phase.WAITING_ON_USER;
    public boolean hasControl = true;
    public boolean turnHasEnded = false;
    public boolean usingCard = false;
    public boolean monsterAttacksQueued = true;
    public static int totalDiscardedThisTurn = 0;
    public static int damageReceivedThisTurn = 0;
    public static int damageReceivedThisCombat = 0;
    public static int playerHpLastTurn;
    public static int redGainedThisCombat;
    public static int greenGainedThisCombat;
    public static int blueGainedThisCombat;
    public static int turn;
    public static ArrayList<ActionLogEntry> actionHistory;

    public void addToNextCombat(AbstractGameAction action) {
        this.nextCombatActions.add(action);
    }

    public void useNextCombatActions() {
        for (AbstractGameAction a : this.nextCombatActions) {
            this.addToBottom(a);
        }
        this.nextCombatActions.clear();
    }

    public void addToBottom(AbstractGameAction action) {
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
            this.actions.add(action);
        }
    }

    public void removeFromQueue(AbstractCard c) {
        int index = -1;
        for (int i = 0; i < this.cardQueue.size(); ++i) {
            if (!this.cardQueue.get((int)i).card.equals(c)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.cardQueue.remove(index);
        }
    }

    public void clearPostCombatActions() {
        Iterator<AbstractGameAction> i = this.actions.iterator();
        while (i.hasNext()) {
            AbstractGameAction e = i.next();
            if (e instanceof HealAction || e instanceof UseCardAction || e.actionType == AbstractGameAction.ActionType.DAMAGE) continue;
            i.remove();
        }
    }

    public void addToTop(AbstractGameAction action) {
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
            this.actions.add(0, action);
        }
    }

    public void addToTurnStart(AbstractGameAction action) {
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
            this.preTurnActions.add(0, action);
        }
    }

    public void update() {
        switch (this.phase) {
            case WAITING_ON_USER: {
                this.getNextAction();
                break;
            }
            case EXECUTING_ACTIONS: {
                if (this.currentAction != null && !this.currentAction.isDone) {
                    this.currentAction.update();
                    break;
                }
                this.previousAction = this.currentAction;
                this.currentAction = null;
                this.getNextAction();
                if (this.currentAction == null && AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT && !this.usingCard) {
                    this.phase = Phase.WAITING_ON_USER;
                    AbstractDungeon.player.hand.refreshHandLayout();
                    this.hasControl = false;
                }
                this.usingCard = false;
                break;
            }
            default: {
                logger.info("This should never be called");
            }
        }
    }

    public void endTurn() {
        this.turnHasEnded = true;
        playerHpLastTurn = AbstractDungeon.player.currentHealth;
    }

    private void getNextAction() {
        if (!this.actions.isEmpty()) {
            this.currentAction = this.actions.remove(0);
            if (this.currentAction.actionType != AbstractGameAction.ActionType.CLEAR_CARD_QUEUE) {
                actionHistory.add(new ActionLogEntry(this.currentAction.actionType));
            }
            this.phase = Phase.EXECUTING_ACTIONS;
            this.hasControl = true;
        } else if (!this.preTurnActions.isEmpty()) {
            this.currentAction = this.preTurnActions.remove(0);
            actionHistory.add(new ActionLogEntry(this.currentAction.actionType));
            this.phase = Phase.EXECUTING_ACTIONS;
            this.hasControl = true;
        } else if (!this.cardQueue.isEmpty()) {
            this.usingCard = true;
            AbstractCard c = this.cardQueue.get((int)0).card;
            if (c.equals(this.lastCard)) {
                logger.info("Last card! " + c.name);
                this.lastCard = null;
            }
            if (c.canUse(AbstractDungeon.player, this.cardQueue.get((int)0).monster) || this.cardQueue.get((int)0).curseException) {
                ++AbstractDungeon.player.cardsPlayedThisTurn;
                this.cardQueue.get((int)0).card.energyOnUse = this.cardQueue.get((int)0).energyOnUse;
                for (AbstractPower abstractPower : AbstractDungeon.player.powers) {
                    abstractPower.onPlayCard(this.cardQueue.get((int)0).card, this.cardQueue.get((int)0).monster);
                }
                for (AbstractRelic abstractRelic : AbstractDungeon.player.relics) {
                    abstractRelic.onPlayCard(this.cardQueue.get((int)0).card, this.cardQueue.get((int)0).monster);
                }
                for (AbstractCard abstractCard : AbstractDungeon.player.hand.group) {
                    abstractCard.onPlayCard(this.cardQueue.get((int)0).card, this.cardQueue.get((int)0).monster);
                }
                for (AbstractCard abstractCard : AbstractDungeon.player.discardPile.group) {
                    abstractCard.onPlayCard(this.cardQueue.get((int)0).card, this.cardQueue.get((int)0).monster);
                }
                for (AbstractCard abstractCard : AbstractDungeon.player.drawPile.group) {
                    abstractCard.onPlayCard(this.cardQueue.get((int)0).card, this.cardQueue.get((int)0).monster);
                }
                this.cardsPlayedThisTurn.add(this.cardQueue.get((int)0).card);
                if (this.cardsPlayedThisTurn.size() == 25) {
                    UnlockTracker.unlockAchievement("INFINITY");
                }
                if (this.cardQueue.get((int)0).card instanceof Shiv) {
                    int shivCount = 0;
                    for (AbstractCard i : this.cardsPlayedThisTurn) {
                        if (!(i instanceof Shiv) || ++shivCount != 10) continue;
                        UnlockTracker.unlockAchievement("NINJA");
                        break;
                    }
                }
                this.cardsPlayedThisCombat.add(this.cardQueue.get((int)0).card);
                AbstractDungeon.player.useCard(this.cardQueue.get((int)0).card, this.cardQueue.get((int)0).monster, this.cardQueue.get((int)0).energyOnUse);
            } else {
                Iterator<AbstractCard> i = AbstractDungeon.player.limbo.group.iterator();
                while (i.hasNext()) {
                    AbstractCard abstractCard = i.next();
                    if (abstractCard != c) continue;
                    c.fadingOut = true;
                    AbstractDungeon.effectList.add(new ExhaustCardEffect(c));
                    i.remove();
                }
                AbstractDungeon.effectList.add(new ThoughtBubble(AbstractDungeon.player.dialogX, AbstractDungeon.player.dialogY, 3.0f, c.cantUseMessage, true));
            }
            this.cardQueue.remove(0);
        } else if (!this.monsterAttacksQueued) {
            this.monsterAttacksQueued = true;
            AbstractDungeon.getCurrRoom().monsters.takeTurn();
        } else if (this.turnHasEnded && !AbstractDungeon.getMonsters().areMonstersBasicallyDead()) {
            AbstractDungeon.getCurrRoom().monsters.applyEndOfTurnPowers();
            AbstractDungeon.player.cardsPlayedThisTurn = 0;
            AbstractDungeon.player.applyStartOfTurnRelics();
            AbstractDungeon.player.applyStartOfTurnCards();
            AbstractDungeon.player.applyStartOfTurnPowers();
            ++turn;
            this.turnHasEnded = false;
            totalDiscardedThisTurn = 0;
            this.cardsPlayedThisTurn.clear();
            damageReceivedThisTurn = 0;
            if (!AbstractDungeon.player.hasPower("Barricade") && !AbstractDungeon.player.hasPower("Blur")) {
                if (!AbstractDungeon.player.hasRelic("Calipers")) {
                    AbstractDungeon.player.loseBlock();
                } else {
                    AbstractDungeon.player.loseBlock(15);
                }
            }
            if (!AbstractDungeon.getCurrRoom().isBattleOver) {
                AbstractDungeon.actionManager.addToBottom(new DrawCardAction(null, AbstractDungeon.player.gameHandSize, true));
                AbstractDungeon.player.applyStartOfTurnPostDrawPowers();
                AbstractDungeon.actionManager.addToBottom(new EnableEndTurnButtonAction());
            }
        }
    }

    public void cleanCardQueue() {
        Iterator<CardQueueItem> i = this.cardQueue.iterator();
        while (i.hasNext()) {
            CardQueueItem e = i.next();
            if (AbstractDungeon.player.hand.contains(e.card)) {
                logger.info("REMOVE: " + e.card.name);
                i.remove();
                continue;
            }
            logger.info("RETAIN: " + e.card.name);
        }
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public void clearNextRoomCombatActions() {
        this.nextCombatActions.clear();
    }

    public void clear() {
        this.actions.clear();
        this.preTurnActions.clear();
        this.currentAction = null;
        this.previousAction = null;
        this.turnStartCurrentAction = null;
        this.cardsPlayedThisCombat.clear();
        this.cardsPlayedThisTurn.clear();
        this.cardQueue.clear();
        redGainedThisCombat = 0;
        greenGainedThisCombat = 0;
        blueGainedThisCombat = 0;
        damageReceivedThisCombat = 0;
        this.turnHasEnded = false;
        turn = 1;
        this.phase = Phase.WAITING_ON_USER;
        totalDiscardedThisTurn = 0;
    }

    public static void incrementDiscard(boolean endOfTurn) {
        ++totalDiscardedThisTurn;
        if (!AbstractDungeon.actionManager.turnHasEnded && !endOfTurn) {
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                r.onManualDiscard();
            }
        }
    }

    public void updateEnergyGain(int redGain, int greenGain, int blueGain) {
        redGainedThisCombat += redGain;
        greenGainedThisCombat += greenGain;
        blueGainedThisCombat += blueGain;
    }

    static {
        turn = 0;
        actionHistory = new ArrayList();
    }

    public static enum Phase {
        WAITING_ON_USER,
        EXECUTING_ACTIONS;

    }
}

