/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.common;

import com.badlogic.gdx.Gdx;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndAddToDeckEffect;

public class MakeTempCardInDeckAction
extends AbstractGameAction {
    private AbstractCard cardToMake;
    private boolean randomSpot = false;
    private boolean cardOffset = false;

    public MakeTempCardInDeckAction(AbstractCreature target, AbstractCreature source, AbstractCard card, int amount, boolean randomSpot, boolean cardOffset) {
        this.setValues(target, source, amount);
        this.actionType = AbstractGameAction.ActionType.CARD_MANIPULATION;
        this.duration = this.DEFAULT_DURATION;
        this.cardToMake = card;
        this.randomSpot = randomSpot;
        this.cardOffset = cardOffset;
    }

    @Override
    public void update() {
        if (this.duration == this.DEFAULT_DURATION) {
            if (this.amount < 6) {
                for (int i = 0; i < this.amount; ++i) {
                    AbstractCard c = this.cardToMake.makeStatEquivalentCopy();
                    AbstractDungeon.effectList.add(new ShowCardAndAddToDeckEffect(c, (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, this.randomSpot, this.cardOffset));
                }
            } else {
                for (int i = 0; i < this.amount; ++i) {
                    AbstractCard c = this.cardToMake.makeStatEquivalentCopy();
                    AbstractDungeon.effectList.add(new ShowCardAndAddToDeckEffect(c, this.randomSpot));
                }
            }
            this.duration -= Gdx.graphics.getDeltaTime();
        }
        this.tickDuration();
    }
}

