/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.common;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class ReducePowerAction
extends AbstractGameAction {
    private String powerID;

    public ReducePowerAction(AbstractCreature target, AbstractCreature source, String power, int amount) {
        this.setValues(target, source, amount);
        this.duration = Settings.ACTION_DUR_FAST;
        this.powerID = power;
        this.actionType = AbstractGameAction.ActionType.REDUCE_POWER;
    }

    @Override
    public void update() {
        if (this.duration == Settings.ACTION_DUR_FAST) {
            for (AbstractPower p : this.target.powers) {
                if (!p.ID.equals(this.powerID)) continue;
                if (this.amount < p.amount) {
                    p.reducePower(this.amount);
                    p.updateDescription();
                    AbstractDungeon.onModifyPower();
                    break;
                }
                AbstractDungeon.actionManager.addToTop(new RemoveSpecificPowerAction(this.target, this.source, this.powerID));
                break;
            }
        }
        this.tickDuration();
    }
}

