/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.common;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.StrengthPower;

public class SpawnMonsterAction
extends AbstractGameAction {
    private boolean used = false;
    private static final float DURATION = 0.1f;
    private AbstractMonster m;

    public SpawnMonsterAction(AbstractMonster m) {
        this.actionType = AbstractGameAction.ActionType.SPECIAL;
        this.duration = 0.1f;
        this.m = m;
        if (AbstractDungeon.player.hasRelic("Philosopher's Stone")) {
            m.addPower(new StrengthPower(m, 2));
        }
    }

    @Override
    public void update() {
        if (!this.used) {
            this.m.init();
            this.m.applyPowers();
            AbstractDungeon.getCurrRoom().monsters.addSpawnedMonster(this.m);
            this.m.showHealthBar();
            if (DailyMods.mods.get("Lethal Enemies").booleanValue()) {
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this.m, this.m, new StrengthPower(this.m, 3), 3));
            }
            this.used = true;
        }
        this.tickDuration();
    }
}

