/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.unique;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAllEnemiesAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;

public class CorpseExplosionAction
extends AbstractGameAction {
    private float startingDuration;
    private boolean triple;

    public CorpseExplosionAction(AbstractCreature target, AbstractCreature source, boolean triple) {
        this.target = target;
        this.source = source;
        this.startingDuration = Settings.ACTION_DUR_FAST;
        this.actionType = AbstractGameAction.ActionType.WAIT;
        this.duration = this.startingDuration;
        this.triple = triple;
    }

    @Override
    public void update() {
        if (this.duration == this.startingDuration) {
            if (this.target.hasPower("Poison")) {
                int damage = this.target.getPower((String)"Poison").amount;
                if (this.triple) {
                    AbstractDungeon.actionManager.addToTop(new DamageAllEnemiesAction(this.source, DamageInfo.createDamageMatrix(damage * 3), DamageInfo.DamageType.NORMAL, AbstractGameAction.AttackEffect.POISON));
                } else {
                    AbstractDungeon.actionManager.addToTop(new DamageAllEnemiesAction(this.source, DamageInfo.createDamageMatrix(damage * 2), DamageInfo.DamageType.NORMAL, AbstractGameAction.AttackEffect.POISON));
                }
                AbstractDungeon.actionManager.addToTop(new RemoveSpecificPowerAction(this.target, this.source, "Poison"));
            } else {
                this.isDone = true;
            }
        }
        this.tickDuration();
    }
}

