/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.unique;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.HealAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;

public class VampireDamageAction
extends AbstractGameAction {
    private DamageInfo info;

    public VampireDamageAction(AbstractCreature target, DamageInfo info, AbstractGameAction.AttackEffect effect) {
        this.info = info;
        this.setValues(target, info);
        this.actionType = AbstractGameAction.ActionType.DAMAGE;
        this.attackEffect = effect;
    }

    @Override
    public void update() {
        if (this.duration == this.DEFAULT_DURATION) {
            AbstractDungeon.effectList.add(new FlashAtkImgEffect(this.target.hb.cX, this.target.hb.cY, this.attackEffect));
        }
        this.tickDuration();
        if (this.isDone) {
            this.heal(this.info);
            this.target.damage(this.info);
            if (AbstractDungeon.getCurrRoom().monsters.areMonstersBasicallyDead()) {
                AbstractDungeon.actionManager.clearPostCombatActions();
            }
        }
    }

    private void heal(DamageInfo info) {
        int healAmount = info.output;
        if (healAmount < 0) {
            return;
        }
        if ((healAmount -= this.target.currentBlock) > this.target.currentHealth) {
            healAmount = this.target.currentHealth;
        }
        if (healAmount > 0) {
            AbstractDungeon.actionManager.addToTop(new HealAction(this.source, this.source, healAmount));
            AbstractDungeon.actionManager.addToTop(new WaitAction(0.1f));
        }
    }
}

