/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.Soul;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoulGroup {
    private static final Logger logger = LogManager.getLogger(SoulGroup.class.getName());
    public static boolean isActive = false;
    private ArrayList<Soul> souls = new ArrayList();
    private static final int DEFAULT_SOUL_CACHE = 20;

    public SoulGroup() {
        for (int i = 0; i < 20; ++i) {
            this.souls.add(new Soul());
        }
    }

    public void discard(AbstractCard card) {
        boolean needMoreSouls = true;
        for (Soul s : this.souls) {
            if (!s.isReadyForReuse) continue;
            card.untip();
            card.unhover();
            s.discard(card);
            needMoreSouls = false;
            break;
        }
        if (needMoreSouls) {
            logger.info("Not enough souls, creating...");
            Soul s = new Soul();
            s.discard(card);
            this.souls.add(s);
        }
    }

    public void empower(AbstractCard card) {
        boolean needMoreSouls = true;
        for (Soul s : this.souls) {
            if (!s.isReadyForReuse) continue;
            card.untip();
            card.unhover();
            s.empower(card);
            needMoreSouls = false;
            break;
        }
        if (needMoreSouls) {
            logger.info("Not enough souls, creating...");
            Soul s = new Soul();
            s.empower(card);
            this.souls.add(s);
        }
    }

    public void obtain(AbstractCard card, boolean obtainCard) {
        CardCrawlGame.sound.play("CARD_OBTAIN");
        boolean needMoreSouls = true;
        for (Soul s : this.souls) {
            if (!s.isReadyForReuse) continue;
            if (obtainCard) {
                s.obtain(card);
            }
            needMoreSouls = false;
            break;
        }
        if (needMoreSouls) {
            logger.info("Not enough souls, creating...");
            Soul s = new Soul();
            if (obtainCard) {
                s.obtain(card);
            }
            this.souls.add(s);
        }
    }

    public void shuffle(AbstractCard card, boolean isInvisible) {
        card.untip();
        card.unhover();
        card.darken(true);
        card.shrink(true);
        boolean needMoreSouls = true;
        for (Soul s : this.souls) {
            if (!s.isReadyForReuse) continue;
            s.shuffle(card, isInvisible);
            needMoreSouls = false;
            break;
        }
        if (needMoreSouls) {
            logger.info("Not enough souls, creating...");
            Soul s = new Soul();
            s.shuffle(card, isInvisible);
            this.souls.add(s);
        }
    }

    public void onToBottomOfDeck(AbstractCard card) {
        boolean needMoreSouls = true;
        for (Soul s : this.souls) {
            if (!s.isReadyForReuse) continue;
            card.untip();
            card.unhover();
            s.onToBottomOfDeck(card);
            needMoreSouls = false;
            break;
        }
        if (needMoreSouls) {
            logger.info("Not enough souls, creating...");
            Soul s = new Soul();
            s.onToBottomOfDeck(card);
            this.souls.add(s);
        }
    }

    public void onToDeck(AbstractCard card, boolean randomSpot) {
        boolean needMoreSouls = true;
        for (Soul s : this.souls) {
            if (!s.isReadyForReuse) continue;
            card.untip();
            card.unhover();
            s.onToDeck(card, randomSpot);
            needMoreSouls = false;
            break;
        }
        if (needMoreSouls) {
            logger.info("Not enough souls, creating...");
            Soul s = new Soul();
            s.onToDeck(card, randomSpot);
            this.souls.add(s);
        }
    }

    public void update() {
        isActive = false;
        for (Soul s : this.souls) {
            if (s.isReadyForReuse) continue;
            isActive = true;
            s.update();
        }
    }

    public void render(SpriteBatch sb) {
        for (Soul s : this.souls) {
            if (s.isReadyForReuse) continue;
            s.render(sb);
        }
    }
}

