/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.ElectricFieldPower;

public class ElectricField
extends AbstractCard {
    public static final String ID = "Electric Field";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Electric Field");
    public static final String NAME = ElectricField.cardStrings.NAME;
    public static final String DESCRIPTION = ElectricField.cardStrings.DESCRIPTION;
    private static final int CHARGE_AMT = 4;
    private static final int UPG_CHARGE = -1;
    private static final int COST = 2;
    private static final int POOL = 1;

    public ElectricField() {
        super(ID, NAME, null, 2, DESCRIPTION, AbstractCard.CardType.POWER, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.SELF, 1);
        this.magicNumber = this.baseMagicNumber = 4;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(p, p, new ElectricFieldPower(NAME, p, this.magicNumber), 1));
    }

    @Override
    public AbstractCard makeCopy() {
        return new ElectricField();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(-1);
            this.initializeDescription();
        }
    }
}

