/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Laser
extends AbstractCard {
    public static final String ID = "Laser";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Laser");
    public static final String NAME = Laser.cardStrings.NAME;
    public static final String DESCRIPTION = Laser.cardStrings.DESCRIPTION;
    private static final int COST = 2;
    private static final int DAMAGE_AMT = 3;
    private static final int INC_AMT = 3;
    private static final int POOL = 1;

    public Laser() {
        super(ID, NAME, null, 2, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.ENEMY, 1);
        this.exhaust = true;
        this.baseDamage = 3;
        this.magicNumber = this.baseMagicNumber = 3;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)m, new DamageInfo(p, this.damage), AbstractGameAction.AttackEffect.FIRE));
        for (AbstractCard c : p.masterDeck.group) {
            if (!(c instanceof Laser) || c.baseDamage != this.baseDamage) continue;
            c.baseDamage += 3;
            break;
        }
        this.baseDamage += 3;
    }

    @Override
    public AbstractCard makeCopy() {
        return new Laser();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeDamage(1);
        }
    }
}

