/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.unique.XBeamAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;

public class XBeam
extends AbstractCard {
    public static final String ID = "X-Beam";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("X-Beam");
    public static final String NAME = XBeam.cardStrings.NAME;
    public static final String DESCRIPTION = XBeam.cardStrings.DESCRIPTION;
    private static final int COST = -1;
    private static final int POOL = 1;

    public XBeam() {
        super(ID, NAME, null, -1, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.ENEMY, 1);
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m, int energyAmount) {
        int effect = energyAmount;
        if (p.hasRelic("Chemical X")) {
            effect += 2;
            p.getRelic("Chemical X").flash();
        }
        if (effect > 0) {
            AbstractDungeon.actionManager.addToBottom(new XBeamAction(m, p, effect));
            p.energy.use(0, 0, EnergyPanel.blueCount);
        }
        p.energy.use(0, EnergyPanel.blueCount, 0);
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m, EnergyPanel.blueCount);
    }

    @Override
    public AbstractCard makeCopy() {
        return new XBeam();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
        }
    }
}

