/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class UnderhandedStrike
extends AbstractCard {
    public static final String ID = "Underhanded Strike";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Underhanded Strike");
    public static final String NAME = UnderhandedStrike.cardStrings.NAME;
    public static final String DESCRIPTION = UnderhandedStrike.cardStrings.DESCRIPTION;
    private static final int COST = -2;
    private static final int POOL = 1;

    public UnderhandedStrike() {
        super(ID, NAME, "green/attack/underhandedStrike", "green/attack/underhandedStrike", -2, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.NONE, 1);
        this.baseDamage = 7;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
    }

    @Override
    public boolean canUse(AbstractPlayer p, AbstractMonster m) {
        this.cantUseMessage = "I can't play this card";
        return false;
    }

    @Override
    public void triggerOnManualDiscard() {
        if (!AbstractDungeon.getMonsters().areMonstersBasicallyDead()) {
            AbstractMonster m = AbstractDungeon.getRandomMonster();
            this.calculateCardDamage(m);
            AbstractDungeon.actionManager.addToTop(new DamageAction((AbstractCreature)m, new DamageInfo(AbstractDungeon.player, this.damage, this.damageTypeForTurn), AbstractGameAction.AttackEffect.SLASH_VERTICAL));
        }
    }

    @Override
    public AbstractCard makeCopy() {
        return new UnderhandedStrike();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeDamage(3);
        }
    }
}

