/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.status;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardQueueItem;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Burn
extends AbstractCard {
    public static final String ID = "Burn";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Burn");
    public static final String NAME = Burn.cardStrings.NAME;
    public static final String DESCRIPTION = Burn.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = Burn.cardStrings.UPGRADE_DESCRIPTION;
    private static final int COST = -2;
    private static final int POOL = 4;
    public int UPG_DAMAGE = 4;
    private int actualBurnDamage = 2;

    public Burn() {
        super(ID, NAME, "status/burn", "status/burn", -2, DESCRIPTION, AbstractCard.CardType.STATUS, AbstractCard.CardColor.COLORLESS, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.NONE, 4);
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        if (p.hasRelic("Medical Kit") && AbstractDungeon.overlayMenu.endTurnButton.blueCandleCurseFlag) {
            this.useMedicalKit(p);
        } else {
            AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, new DamageInfo(AbstractDungeon.player, this.actualBurnDamage, DamageInfo.DamageType.THORNS), AbstractGameAction.AttackEffect.FIRE));
        }
    }

    @Override
    public void triggerOnEndOfTurnForPlayingCard() {
        AbstractDungeon.actionManager.cardQueue.add(new CardQueueItem((AbstractCard)this, null, true));
    }

    @Override
    public AbstractCard makeCopy() {
        Burn retVal = new Burn();
        return retVal;
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.actualBurnDamage = this.UPG_DAMAGE;
            this.rawDescription = UPGRADE_DESCRIPTION;
            this.initializeDescription();
        }
    }
}

