/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;

public class ExceptionHandler {
    public static void handleException(Exception e, Logger logger) {
        ExceptionHandler.saveCrashLog(e);
        logger.error("Exception caught", (Throwable)e);
    }

    public static void saveCrashLog(Exception e) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("America/Los_Angeles"));
        File log = new File("crashlogs/" + Long.toString(cal.getTimeInMillis()) + ".txt");
        log.getParentFile().mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(log, "UTF-8");
        }
        catch (FileNotFoundException | UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        if (e != null && writer != null) {
            writer.println(e.getMessage());
            for (StackTraceElement element : e.getStackTrace()) {
                writer.println(element.toString());
            }
            writer.close();
        }
    }
}

