/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.daily;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.google.gson.Gson;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.TimeHelper;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.random.Random;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import com.megacrit.cardcrawl.screens.stats.RunData;
import com.megacrit.cardcrawl.ui.buttons.ConfirmButton;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DailyScreen {
    private static final Logger logger = LogManager.getLogger(DailyScreen.class.getName());
    private long lastDaily = 0L;
    public AbstractPlayer.PlayerClass todaysChar = null;
    private String charName;
    public static final String daily_save_path = "runs" + File.separator + "DAILY";
    private Color screenColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private float alphaTarget = 0.0f;
    private MenuCancelButton cancelButton = new MenuCancelButton();
    private ConfirmButton confirmButton = new ConfirmButton("Start");
    private float screenX = -1100.0f * Settings.scale;
    private float targetX = -1100.0f * Settings.scale;
    private float dateOffsetX;
    private Preferences pref;
    private static final String LAST_DAILY = "LAST_DAILY";
    private DateFormat dFormat;
    private float retryTimer = 0.0f;
    private static float retryTime = 0.5f;
    private static int retryCount = 5;
    private ArrayList<Thread> threads = new ArrayList();
    private boolean stopTrying = false;
    private boolean timeUpdated = false;
    private Random random;
    private RunData data = null;

    public DailyScreen() {
        this.pref = Gdx.app.getPreferences("STSDaily");
        this.lastDaily = this.pref.getLong(LAST_DAILY, -1L);
        this.dateOffsetX = FontHelper.getSmartWidth(FontHelper.charTitleFont, "Daily Ascent", 9999.0f, 0.0f) + 20.0f * Settings.scale;
    }

    public void update() {
        FileHandle[] files;
        this.cancelButton.update();
        if (this.cancelButton.hb.clicked) {
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
            this.hide();
        }
        this.confirmButton.update();
        this.screenColor.a = MathHelper.popLerpSnap(this.screenColor.a, this.alphaTarget);
        this.screenX = MathHelper.uiLerpSnap(this.screenX, this.targetX);
        this.pingTimeServer();
        if (this.confirmButton.hitbox.clicked) {
            this.confirmButton.hitbox.clicked = false;
            CardCrawlGame.mainMenuScreen.isFadingOut = true;
            this.hide();
            this.pref.putLong(LAST_DAILY, TimeHelper.daySince1970);
            this.pref.flush();
            Settings.isTrial = false;
            Settings.isDailyRun = true;
            CardCrawlGame.mainMenuScreen.fadeOutMusic();
        }
        if (this.lastDaily == TimeHelper.daySince1970 && this.data == null && (files = Gdx.files.local(daily_save_path + File.separator).list()).length != 0) {
            Gson gson = new Gson();
            this.data = gson.fromJson(files[files.length - 1].readString(), RunData.class);
            logger.info("GOT DATA!");
        }
    }

    private void pingTimeServer() {
        if (TimeHelper.isTimeSet && !this.timeUpdated) {
            this.timeUpdated = true;
            this.stopTrying = true;
            for (Thread t : this.threads) {
                t.interrupt();
            }
            this.dFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            this.dFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
            this.determineLoadout();
        } else if (!this.stopTrying) {
            this.retryTimer -= Gdx.graphics.getDeltaTime();
            if (this.retryTimer < 0.0f) {
                Thread t2 = new Thread(CardCrawlGame.myRunnable);
                t2.start();
                this.threads.add(t2);
                this.retryTimer = retryTime;
                if (--retryCount == 0) {
                    this.stopTrying = true;
                }
            }
        }
    }

    public void determineLoadout() {
        this.random = new Random(TimeHelper.daySince1970);
        int loadout = this.random.random(8);
        Settings.dailyMods.initialize(this.random);
        Settings.seed = this.random.randomLong();
        AbstractDungeon.generateSeeds();
        switch (loadout) {
            case 0: {
                this.todaysChar = AbstractPlayer.PlayerClass.IRONCLAD;
                break;
            }
            case 1: {
                this.todaysChar = AbstractPlayer.PlayerClass.IRONCLAD;
                break;
            }
            case 2: {
                this.todaysChar = AbstractPlayer.PlayerClass.IRONCLAD;
                break;
            }
            case 3: {
                this.todaysChar = AbstractPlayer.PlayerClass.IRONCLAD;
                break;
            }
            case 4: {
                this.todaysChar = AbstractPlayer.PlayerClass.IRONCLAD;
                break;
            }
            case 5: {
                this.todaysChar = AbstractPlayer.PlayerClass.THE_SILENT;
                break;
            }
            case 6: {
                this.todaysChar = AbstractPlayer.PlayerClass.THE_SILENT;
                break;
            }
            case 7: {
                this.todaysChar = AbstractPlayer.PlayerClass.THE_SILENT;
                break;
            }
            default: {
                this.todaysChar = AbstractPlayer.PlayerClass.THE_SILENT;
            }
        }
        this.charName = AbstractPlayer.getClass(this.todaysChar);
        if (this.lastDaily != TimeHelper.daySince1970) {
            this.confirmButton.isDisabled = false;
            this.confirmButton.show();
        } else {
            this.confirmButton.hide();
        }
        logger.info("Today's loadout is: " + loadout);
    }

    public void show() {
        CardCrawlGame.mainMenuScreen.darken();
        this.alphaTarget = 0.8f;
        this.cancelButton.show("Return");
        this.targetX = 100.0f * Settings.scale;
        if (this.lastDaily != TimeHelper.daySince1970) {
            this.confirmButton.isDisabled = false;
            this.confirmButton.show();
        }
    }

    public void hide() {
        CardCrawlGame.mainMenuScreen.lighten();
        this.alphaTarget = 0.0f;
        this.cancelButton.hide();
        this.targetX = -1100.0f * Settings.scale;
        this.confirmButton.hide();
    }

    public void render(SpriteBatch sb) {
        this.cancelButton.render(sb);
        this.confirmButton.render(sb);
        if (TimeHelper.isTimeSet) {
            FontHelper.renderSmartText(sb, FontHelper.charTitleFont, "Daily Ascent", this.screenX + 50.0f * Settings.scale, 850.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Settings.GOLD_COLOR);
            FontHelper.renderSmartText(sb, FontHelper.charDescFont, TimeHelper.getTodayDate(), this.screenX + this.dateOffsetX + 50.0f * Settings.scale, 850.0f * Settings.scale - 10.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Color.SKY);
            if (this.lastDaily != TimeHelper.daySince1970) {
                FontHelper.renderSmartText(sb, FontHelper.charDescFont, "Time Left: " + TimeHelper.getTimeLeft(), this.screenX + 50.0f * Settings.scale, 786.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Settings.CREAM_COLOR);
            } else {
                FontHelper.renderSmartText(sb, FontHelper.charDescFont, "You have done today's challenge", this.screenX + 50.0f * Settings.scale, 786.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Settings.CREAM_COLOR);
            }
            if (this.lastDaily == TimeHelper.daySince1970 && this.data != null) {
                FontHelper.renderSmartText(sb, FontHelper.charDescFont, "#yFloor #yReached: NL  " + this.data.floor_reached + " NL NL  #yDeck: NL " + this.data.master_deck + " NL NL  #yRelics: NL  " + this.data.relics, this.screenX + 50.0f * Settings.scale, 726.0f * Settings.scale, 500.0f * Settings.scale, 32.0f * Settings.scale, Settings.CREAM_COLOR);
            } else if (this.todaysChar != null) {
                FontHelper.renderSmartText(sb, FontHelper.charDescFont, " NL Today's Challenge: NL TAB #yClass: NL TAB " + this.charName + " NL TAB #yMods: " + Settings.dailyMods.todaysMods, this.screenX + 50.0f * Settings.scale, 726.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Settings.CREAM_COLOR);
            }
        } else {
            FontHelper.renderSmartText(sb, FontHelper.charTitleFont, "#yDaily #yAscent", this.screenX + 50.0f * Settings.scale, 850.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Settings.CREAM_COLOR);
            FontHelper.renderSmartText(sb, FontHelper.charDescFont, "Connecting to Server...", this.screenX + 50.0f * Settings.scale, 786.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Settings.CREAM_COLOR);
        }
    }
}

