/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.dungeons;

import com.badlogic.gdx.graphics.Color;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.gashapon.GashaponRoom;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.monsters.MonsterInfo;
import com.megacrit.cardcrawl.random.Random;
import com.megacrit.cardcrawl.rooms.EmptyRoom;
import com.megacrit.cardcrawl.scenes.TheBottomScene;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveFile;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.Collections;

public class Exordium
extends AbstractDungeon {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("Exordium");
    public static final String[] TEXT = Exordium.uiStrings.TEXT;
    public static final String NAME = TEXT[0];
    public static final String ID = "Exordium";

    public Exordium(AbstractPlayer p, ArrayList<String> emptyList) {
        super(NAME, ID, p, emptyList);
        this.initializeRelicList();
        if (scene != null) {
            scene.dispose();
        }
        scene = new TheBottomScene();
        scene.randomizeScene();
        fadeColor = Color.valueOf("1e0f0aff");
        this.initializeSpecialOneTimeEventList();
        this.initializeLevelSpecificChances();
        mapRng = new Random(Settings.seed);
        Exordium.generateMap();
        CardCrawlGame.music.changeBGM(id);
        AbstractDungeon.currMapNode = new MapRoomNode(0, -1);
        AbstractDungeon.currMapNode.room = Settings.isShowBuild || TipTracker.tips.get("NEOW_SKIP") == false ? new EmptyRoom() : new GashaponRoom();
    }

    public Exordium(AbstractPlayer p, SaveFile saveFile) {
        super(NAME, p, saveFile);
        CardCrawlGame.dungeon = this;
        if (scene != null) {
            scene.dispose();
        }
        scene = new TheBottomScene();
        fadeColor = Color.valueOf("1e0f0aff");
        this.initializeLevelSpecificChances();
        CardCrawlGame.music.changeBGM(id);
        mapRng = new Random(Settings.seed);
        Exordium.generateMap();
        firstRoomChosen = true;
        this.populatePathTaken(saveFile);
    }

    @Override
    protected void initializeLevelSpecificChances() {
        shopRoomChance = 0.05f;
        restRoomChance = 0.12f;
        treasureRoomChance = 0.0f;
        eventRoomChance = 0.22f;
        eliteRoomChance = 0.08f;
        smallChestChance = 50;
        mediumChestChance = 33;
        largeChestChance = 17;
        smallPotionChance = 90;
        mediumPotionChance = 10;
        largePotionChance = 0;
        commonRelicChance = 50;
        uncommonRelicChance = 33;
        rareRelicChance = 17;
        colorlessRareChance = 0.3f;
        cardUpgradedChance = 0.0f;
    }

    @Override
    protected void generateMonsters() {
        ArrayList<MonsterInfo> monsters = new ArrayList<MonsterInfo>();
        monsters.add(new MonsterInfo("Looter", 2.0f));
        monsters.add(new MonsterInfo("JawWorm", 2.0f));
        monsters.add(new MonsterInfo("Cultist", 2.0f));
        monsters.add(new MonsterInfo("Blue Slaver", 2.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateMonsterList(monsters, 3, false);
        monsters.clear();
        monsters.add(new MonsterInfo("FungiBeast", 2.0f));
        monsters.add(new MonsterInfo("Louse", 2.0f));
        monsters.add(new MonsterInfo("Gremlins", 1.0f));
        monsters.add(new MonsterInfo("Exordium Wildlife", 1.5f));
        monsters.add(new MonsterInfo("Exordium Thugs", 1.5f));
        monsters.add(new MonsterInfo("Red Slaver", 1.0f));
        monsters.add(new MonsterInfo("Slime", 2.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateFirstStrongEnemy(monsters, this.generateExclusions());
        this.populateMonsterList(monsters, 12, false);
        monsters.clear();
        monsters.add(new MonsterInfo("GremlinNob", 1.0f));
        monsters.add(new MonsterInfo("Lagavulin", 1.0f));
        monsters.add(new MonsterInfo("Sentries", 1.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateMonsterList(monsters, 5, true);
    }

    @Override
    protected ArrayList<String> generateExclusions() {
        ArrayList<String> retVal = new ArrayList<String>();
        switch ((String)monsterList.get(monsterList.size() - 1)) {
            case "Looter": {
                retVal.add("Exordium Thugs");
                break;
            }
            case "JawWorm": {
                break;
            }
            case "Cultist": {
                break;
            }
            case "Blue Slaver": {
                retVal.add("Red Slaver");
                retVal.add("Exordium Thugs");
                break;
            }
        }
        return retVal;
    }

    @Override
    protected void initializeBoss() {
        if (!UnlockTracker.isBossSeen("GUARDIAN")) {
            bossList.add("TheGuardian");
        } else if (!UnlockTracker.isBossSeen("GHOST")) {
            bossList.add("Hexaghost");
        } else if (!UnlockTracker.isBossSeen("SLIME")) {
            bossList.add("SlimeBoss");
        } else {
            bossList.add("TheGuardian");
            bossList.add("Hexaghost");
            bossList.add("SlimeBoss");
            Collections.shuffle(bossList);
        }
        if (Settings.isDemo) {
            bossList.clear();
            bossList.add("Hexaghost");
        }
    }

    @Override
    protected void initializeEventList() {
        eventList.add("Big Fish");
        eventList.add("The Cleric");
        eventList.add("Dead Adventurer");
        eventList.add("Golden Idol");
        eventList.add("Golden Wing");
        eventList.add("World of Goop");
        eventList.add("Liars Game");
        eventList.add("Living Wall");
        eventList.add("Mushrooms");
        eventList.add("Scrap Ooze");
        eventList.add("Shining Light");
    }

    @Override
    protected void initializeShrineList() {
        shrineList.add("Match and Keep!");
        shrineList.add("Golden Shrine");
        shrineList.add("Transmorgrifier");
        shrineList.add("Purifier");
        shrineList.add("Upgrade Shrine");
        shrineList.add("Wheel of Change");
    }

    @Override
    protected void initializeEventImg() {
        if (eventImg != null) {
            eventImg.dispose();
            eventImg = null;
        }
        eventImg = ImageMaster.loadImage("images/ui/event/panel.png");
    }
}

