/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.dungeons;

import com.badlogic.gdx.graphics.Color;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.monsters.MonsterInfo;
import com.megacrit.cardcrawl.random.Random;
import com.megacrit.cardcrawl.rooms.EmptyRoom;
import com.megacrit.cardcrawl.scenes.TheCityScene;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveFile;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TheCity
extends AbstractDungeon {
    private static final Logger logger = LogManager.getLogger(TheCity.class.getName());
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("TheCity");
    public static final String[] TEXT = TheCity.uiStrings.TEXT;
    public static final String NAME = TEXT[0];
    public static final String ID = "TheCity";

    public TheCity(AbstractPlayer p, ArrayList<String> theList) {
        super(NAME, ID, p, theList);
        this.removeRelicFromPool(bossRelicPool, "Ectoplasm");
        if (scene != null) {
            scene.dispose();
        }
        scene = new TheCityScene();
        fadeColor = Color.valueOf("0a1e1eff");
        this.initializeLevelSpecificChances();
        mapRng = new Random(Settings.seed, 100);
        TheCity.generateMap();
        CardCrawlGame.music.changeBGM(id);
        AbstractDungeon.currMapNode = new MapRoomNode(0, -1);
        AbstractDungeon.currMapNode.room = new EmptyRoom();
    }

    public TheCity(AbstractPlayer p, SaveFile saveFile) {
        super(NAME, p, saveFile);
        if (scene != null) {
            scene.dispose();
        }
        scene = new TheCityScene();
        fadeColor = Color.valueOf("0a1e1eff");
        this.initializeLevelSpecificChances();
        CardCrawlGame.music.changeBGM(id);
        mapRng = new Random(Settings.seed, 100);
        TheCity.generateMap();
        firstRoomChosen = true;
        this.populatePathTaken(saveFile);
    }

    @Override
    protected void initializeLevelSpecificChances() {
        shopRoomChance = 0.05f;
        restRoomChance = 0.12f;
        treasureRoomChance = 0.0f;
        eventRoomChance = 0.22f;
        eliteRoomChance = 0.08f;
        smallChestChance = 50;
        mediumChestChance = 33;
        largeChestChance = 17;
        smallPotionChance = 70;
        mediumPotionChance = 30;
        largePotionChance = 0;
        commonRelicChance = 50;
        uncommonRelicChance = 33;
        rareRelicChance = 17;
        colorlessRareChance = 0.3f;
        cardUpgradedChance = 0.25f;
    }

    @Override
    protected void generateMonsters() {
        ArrayList<MonsterInfo> monsters = new ArrayList<MonsterInfo>();
        monsters.add(new MonsterInfo("SphericGuardian", 2.0f));
        monsters.add(new MonsterInfo("3_Byrds", 2.0f));
        monsters.add(new MonsterInfo("Chosen", 2.0f));
        monsters.add(new MonsterInfo("Shelled Parasite", 2.0f));
        monsters.add(new MonsterInfo("City Looters", 2.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateMonsterList(monsters, 2, false);
        monsters.clear();
        monsters.add(new MonsterInfo("Murder of Cultists", 4.0f));
        monsters.add(new MonsterInfo("Snecko", 4.0f));
        monsters.add(new MonsterInfo("SnakePlant", 6.0f));
        monsters.add(new MonsterInfo("HealerTank", 6.0f));
        monsters.add(new MonsterInfo("Chosen and Flock", 2.0f));
        monsters.add(new MonsterInfo("City Thugs", 2.0f));
        monsters.add(new MonsterInfo("City Ancients", 2.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateFirstStrongEnemy(monsters, this.generateExclusions());
        this.populateMonsterList(monsters, 12, false);
        monsters.clear();
        monsters.add(new MonsterInfo("SlaverBoss", 1.0f));
        monsters.add(new MonsterInfo("BookOfStabbing", 1.0f));
        monsters.add(new MonsterInfo("Gremlin Leader Combat", 1.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateMonsterList(monsters, 5, true);
        logger.info("Random counter: " + TheCity.monsterRng.counter);
    }

    @Override
    protected ArrayList<String> generateExclusions() {
        ArrayList<String> retVal = new ArrayList<String>();
        switch ((String)monsterList.get(monsterList.size() - 1)) {
            case "SphericGuardian": {
                retVal.add("City Ancients");
                break;
            }
            case "Byrd": {
                retVal.add("Chosen and Flock");
                break;
            }
            case "Chosen": {
                retVal.add("Chosen and Flock");
                break;
            }
            case "Shelled Parasite": {
                retVal.add("City Thugs");
                break;
            }
        }
        return retVal;
    }

    @Override
    protected void initializeBoss() {
        if (!UnlockTracker.isBossSeen("CHAMP")) {
            bossList.add("Champ");
        } else if (!UnlockTracker.isBossSeen("AUTOMATON")) {
            bossList.add("BronzeAutomaton");
        } else if (!UnlockTracker.isBossSeen("COLLECTOR")) {
            bossList.add("TheCollector");
        } else {
            bossList.add("BronzeAutomaton");
            bossList.add("TheCollector");
            bossList.add("Champ");
            Collections.shuffle(bossList);
        }
    }

    @Override
    protected void initializeEventList() {
        eventList.add("Addict");
        eventList.add("Back to Basics");
        eventList.add("Beggar");
        eventList.add("Drug Dealer");
        if (Settings.isBeta) {
            eventList.add("Masked Bandits");
        }
        eventList.add("The Mausoleum");
        eventList.add("Vampires");
        eventList.add("Cursed Tome");
        eventList.add("The Library");
        eventList.add("Forgotten Altar");
    }

    @Override
    protected void initializeEventImg() {
        if (eventImg != null) {
            eventImg.dispose();
            eventImg = null;
        }
        eventImg = ImageMaster.loadImage("images/ui/event/panel.png");
    }

    @Override
    protected void initializeShrineList() {
        shrineList.add("Match and Keep!");
        shrineList.add("Wheel of Change");
        shrineList.add("Golden Shrine");
        shrineList.add("Transmorgrifier");
        shrineList.add("Purifier");
        shrineList.add("Upgrade Shrine");
    }
}

