/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.vfx.scene.EventBgParticle;

public abstract class AbstractImageEvent
extends AbstractEvent {
    protected String title = "";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Proceed Screen");
    public static final String[] DESCRIPTIONS = AbstractImageEvent.eventStrings.DESCRIPTIONS;

    public AbstractImageEvent(String title, String body, String imgUrl) {
        this.title = title;
        this.body = body;
        AbstractDungeon.genericEventDialog.loadImage(imgUrl);
        type = AbstractEvent.EventType.IMAGE;
    }

    @Override
    public void update() {
        this.hasFocus = true;
        if (MathUtils.randomBoolean(0.1f)) {
            AbstractDungeon.effectList.add(new EventBgParticle());
        }
        if (this.waitTimer > 0.0f) {
            this.waitTimer -= Gdx.graphics.getDeltaTime();
            if (this.waitTimer < 0.0f) {
                AbstractDungeon.genericEventDialog.show(this.title, this.body);
                this.waitTimer = 0.0f;
            }
        }
        if (!GenericEventDialog.waitForInput) {
            this.buttonEffect(GenericEventDialog.getSelectedOption());
        }
    }

    @Override
    public void showProceedScreen(String bodyText) {
        GenericEventDialog.updateBodyText(bodyText);
        GenericEventDialog.updateDialogOption(0, DESCRIPTIONS[0]);
        GenericEventDialog.clearRemainingOptions();
        this.screenNum = 99;
    }

    protected abstract void buttonEffect(int var1);

    @Override
    public void render(SpriteBatch sb) {
    }

    @Override
    protected void openMap() {
        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
        AbstractDungeon.dungeonMapScreen.open(false);
    }
}

