/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.rooms.AbstractRoom;

public abstract class AbstractTextEvent
extends AbstractEvent {
    protected String title = "";

    public AbstractTextEvent(String title, String body) {
        this.title = title;
        this.body = body;
        type = AbstractEvent.EventType.TEXT;
    }

    @Override
    public void update() {
        this.hasFocus = true;
        if (this.waitTimer > 0.0f) {
            this.waitTimer -= Gdx.graphics.getDeltaTime();
            if (this.waitTimer < 0.0f) {
                AbstractDungeon.genericEventDialog.show(this.title, this.body);
                this.waitTimer = 0.0f;
            }
        }
        if (!GenericEventDialog.waitForInput) {
            this.buttonEffect(GenericEventDialog.getSelectedOption());
        }
    }

    @Override
    public void showProceedScreen(String bodyText) {
        GenericEventDialog.updateBodyText(bodyText);
        GenericEventDialog.updateDialogOption(0, "[ #bProceed ]");
        GenericEventDialog.clearRemainingOptions();
        this.screenNum = 99;
    }

    protected abstract void buttonEffect(int var1);

    @Override
    public void render(SpriteBatch sb) {
    }

    @Override
    protected void openMap() {
        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
        AbstractDungeon.dungeonMapScreen.open(false);
    }
}

