/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;

public class OLDGoopPuddle
extends AbstractEvent {
    public static final String NAME = "Goop Puddle";
    private Texture img = ImageMaster.loadImage("images/npcs/goop.png");
    private static final String DIALOG_1 = "You see a goopy puddle on the floor. NL Your childish instincts tell you to jump up and down in it. NL However, your common sense tells you to leave suspicious things alone.";
    private static final String DIALOG_2 = "You jump up and down in the suspicious puddle and have a great time. NL The puddle contained a strange enzyme that makes you forget things. NL A #brandom card was removed from your deck.";
    private static final String DIALOG_3 = "NL You're too old for this.";
    private AbstractCard purgedCard = null;

    public OLDGoopPuddle() {
        this.drawX = (float)Settings.WIDTH * 0.75f;
        this.drawY = AbstractDungeon.floorY;
        this.body = DIALOG_1;
        RoomEventDialog.addDialogOption("Jump up and down in it. [ #gRemove a #brandom card ]");
        RoomEventDialog.addDialogOption("Nope. [ #bLeave ]");
        this.hasDialog = true;
        this.hasFocus = true;
    }

    @Override
    public void update() {
        super.update();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    private void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        this.purgedCard = AbstractDungeon.player.masterDeck.getRandomCard(false);
                        AbstractDungeon.player.masterDeck.removeCard(this.purgedCard);
                        AbstractDungeon.effectList.add(new PurgeCardEffect(this.purgedCard));
                        this.logMetric(true);
                        this.showProceedScreen(DIALOG_2);
                        break block0;
                    }
                }
                this.logMetric(false);
                this.showProceedScreen(DIALOG_3);
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(boolean usedPuddle) {
        String actionTaken = "puddle used";
        if (!usedPuddle) {
            actionTaken = "puddle not used";
        }
        AbstractEvent.logMetric(NAME, actionTaken);
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(this.img, this.drawX - (float)this.img.getWidth() * Settings.scale / 2.0f, this.drawY, (float)this.img.getWidth() * Settings.scale, (float)this.img.getHeight() * Settings.scale, 0, 0, this.img.getWidth(), this.img.getHeight(), false, false);
    }
}

