/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.shrines;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;

public class Bonfire
extends AbstractImageEvent {
    public static final String ID = "Bonfire Elementals";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Bonfire Elementals");
    public static final String NAME = Bonfire.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = Bonfire.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = Bonfire.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String DIALOG_2 = DESCRIPTIONS[1];
    private static final String DIALOG_3 = DESCRIPTIONS[2];
    private CUR_SCREEN screen = CUR_SCREEN.INTRO;
    private AbstractCard offeredCard = null;
    private boolean cardSelect = false;

    public Bonfire() {
        super(NAME, DIALOG_1, "images/events/bonfire.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
    }

    @Override
    public void update() {
        super.update();
        if (this.cardSelect && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            this.offeredCard = AbstractDungeon.gridSelectScreen.selectedCards.remove(0);
            this.setReward(this.offeredCard.rarity);
            this.logMetric(this.offeredCard.cardID);
            AbstractDungeon.topLevelEffects.add(new PurgeCardEffect(this.offeredCard, Settings.WIDTH / 2, Settings.HEIGHT / 2));
            AbstractDungeon.player.masterDeck.removeCard(this.offeredCard);
            GenericEventDialog.updateDialogOption(0, OPTIONS[1]);
            this.screen = CUR_SCREEN.COMPLETE;
            this.cardSelect = false;
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                GenericEventDialog.updateBodyText(DIALOG_2);
                GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                this.screen = CUR_SCREEN.CHOOSE;
                break;
            }
            case CHOOSE: {
                AbstractDungeon.gridSelectScreen.open(CardGroup.getGroupWithoutBottledCards(AbstractDungeon.player.masterDeck.getPurgeableCards()), 1, OPTIONS[3], false, false, false, true);
                this.cardSelect = true;
                break;
            }
            case COMPLETE: {
                this.openMap();
            }
        }
    }

    private void setReward(AbstractCard.CardRarity rarity) {
        String dialog = DIALOG_3;
        switch (rarity) {
            case CURSE: {
                dialog = dialog + DESCRIPTIONS[3];
                AbstractDungeon.getCurrRoom().spawnRelicAndObtain((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, RelicLibrary.getRelic("Spirit Poop").makeCopy());
                break;
            }
            case BASIC: {
                dialog = dialog + DESCRIPTIONS[4];
                break;
            }
            case COMMON: {
                dialog = dialog + DESCRIPTIONS[5];
                AbstractDungeon.player.heal(5);
                break;
            }
            case UNCOMMON: {
                dialog = dialog + DESCRIPTIONS[6];
                AbstractDungeon.player.heal(AbstractDungeon.player.maxHealth);
                break;
            }
            case RARE: {
                dialog = dialog + DESCRIPTIONS[7];
                AbstractDungeon.player.increaseMaxHp(10, false);
                AbstractDungeon.player.heal(AbstractDungeon.player.maxHealth);
                break;
            }
        }
        GenericEventDialog.updateBodyText(dialog);
    }

    public void logMetric(String cardGiven) {
        AbstractEvent.logMetric(ID, cardGiven);
    }

    private static enum CUR_SCREEN {
        INTRO,
        CHOOSE,
        COMPLETE;

    }
}

