/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.shrines;

import com.megacrit.cardcrawl.cards.curses.Regret;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.RainingGoldEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class GoldShrine
extends AbstractImageEvent {
    public static final String ID = "Golden Shrine";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Golden Shrine");
    public static final String NAME = GoldShrine.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = GoldShrine.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = GoldShrine.eventStrings.OPTIONS;
    private static final int GOLD_AMT = 100;
    private static final int CURSE_GOLD_AMT = 250;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String DIALOG_2 = DESCRIPTIONS[1];
    private static final String DIALOG_3 = DESCRIPTIONS[2];
    private static final String IGNORE = DESCRIPTIONS[3];
    private CUR_SCREEN screen = CUR_SCREEN.INTRO;

    public GoldShrine() {
        super(NAME, DIALOG_1, "images/events/goldShrine.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        GenericEventDialog.setDialogOption(OPTIONS[1], CardLibrary.getCopy("Regret"));
        GenericEventDialog.setDialogOption(OPTIONS[2]);
    }

    @Override
    public void onEnterRoom() {
        CardCrawlGame.music.playTempBGM("SHRINE");
    }

    @Override
    public void update() {
        super.update();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        this.screen = CUR_SCREEN.COMPLETE;
                        GoldShrine.logMetric(ID, "Pray");
                        GenericEventDialog.updateBodyText(DIALOG_2);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        AbstractDungeon.effectList.add(new RainingGoldEffect(100));
                        AbstractDungeon.player.gainGold(100);
                        GenericEventDialog.clearRemainingOptions();
                        break;
                    }
                    case 1: {
                        this.screen = CUR_SCREEN.COMPLETE;
                        GoldShrine.logMetric(ID, "Desecrate");
                        AbstractDungeon.effectList.add(new RainingGoldEffect(250));
                        AbstractDungeon.player.gainGold(250);
                        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Regret(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                        UnlockTracker.markCardAsSeen("Regret");
                        GenericEventDialog.updateBodyText(DIALOG_3);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        GenericEventDialog.clearRemainingOptions();
                        break;
                    }
                    case 2: {
                        this.screen = CUR_SCREEN.COMPLETE;
                        GoldShrine.logMetric(ID, "Skipped");
                        GenericEventDialog.updateBodyText(IGNORE);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        GenericEventDialog.clearRemainingOptions();
                    }
                }
                break;
            }
            case COMPLETE: {
                this.openMap();
            }
        }
    }

    public void logMetric(String result) {
        AbstractEvent.logMetric(ID, result);
    }

    private static enum CUR_SCREEN {
        INTRO,
        COMPLETE;

    }
}

