/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.shrines;

import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.PotionHelper;
import com.megacrit.cardcrawl.helpers.ScreenShake;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rooms.AbstractRoom;

public class WomanInBlue
extends AbstractImageEvent {
    public static final String ID = "The Woman in Blue";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("The Woman in Blue");
    public static final String NAME = WomanInBlue.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = WomanInBlue.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = WomanInBlue.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final int cost1 = 20;
    private static final int cost2 = 30;
    private static final int cost3 = 40;
    private CurScreen screen = CurScreen.INTRO;

    public WomanInBlue() {
        super(NAME, DIALOG_1, "images/events/ladyInBlue.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0] + 20 + OPTIONS[3] + ".");
        GenericEventDialog.setDialogOption(OPTIONS[1] + 30 + OPTIONS[3] + ".");
        GenericEventDialog.setDialogOption(OPTIONS[2] + 40 + OPTIONS[3] + ".");
        GenericEventDialog.setDialogOption(OPTIONS[4]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        AbstractDungeon.player.loseGold(20);
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[1]);
                        this.logMetric("Bought 1 Potion");
                        AbstractDungeon.getCurrRoom().rewards.clear();
                        AbstractDungeon.getCurrRoom().rewards.add(new RewardItem(PotionHelper.getRandomPotion()));
                        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
                        AbstractDungeon.combatRewardScreen.open();
                        break;
                    }
                    case 1: {
                        AbstractDungeon.player.loseGold(30);
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[1]);
                        this.logMetric("Bought 2 Potions");
                        AbstractDungeon.getCurrRoom().rewards.clear();
                        AbstractDungeon.getCurrRoom().rewards.add(new RewardItem(PotionHelper.getRandomPotion()));
                        AbstractDungeon.getCurrRoom().rewards.add(new RewardItem(PotionHelper.getRandomPotion()));
                        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
                        AbstractDungeon.combatRewardScreen.open();
                        break;
                    }
                    case 2: {
                        AbstractDungeon.player.loseGold(40);
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[1]);
                        this.logMetric("Bought 3 Potions");
                        AbstractDungeon.getCurrRoom().rewards.clear();
                        AbstractDungeon.getCurrRoom().rewards.add(new RewardItem(PotionHelper.getRandomPotion()));
                        AbstractDungeon.getCurrRoom().rewards.add(new RewardItem(PotionHelper.getRandomPotion()));
                        AbstractDungeon.getCurrRoom().rewards.add(new RewardItem(PotionHelper.getRandomPotion()));
                        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
                        AbstractDungeon.combatRewardScreen.open();
                        break;
                    }
                    case 3: {
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[2]);
                        CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.MED, ScreenShake.ShakeDur.MED, false);
                        CardCrawlGame.sound.play("BLUNT_FAST");
                        this.logMetric("Bought 0 Potions");
                    }
                }
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[4]);
                this.screen = CurScreen.RESULT;
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        RESULT;

    }
}

