/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebeyond;

import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.ScreenShake;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.RainingGoldEffect;

public class MoaiHead
extends AbstractImageEvent {
    public static final String ID = "The Moai Head";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("The Moai Head");
    public static final String NAME = MoaiHead.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = MoaiHead.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = MoaiHead.eventStrings.OPTIONS;
    private static final int goldAmount = 333;
    private static final String INTRO_BODY = DESCRIPTIONS[0];
    public static final float hpCheck = 0.35f;
    private int screenNum = 0;

    public MoaiHead() {
        super(NAME, INTRO_BODY, "images/events/moaiHead.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        if (AbstractDungeon.player.hasRelic("Golden Idol")) {
            GenericEventDialog.setDialogOption(OPTIONS[1], !AbstractDungeon.player.hasRelic("Golden Idol"));
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[2], !AbstractDungeon.player.hasRelic("Golden Idol"));
        }
        GenericEventDialog.setDialogOption(OPTIONS[3]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        this.logMetric("Heal");
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[1]);
                        CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.HIGH, ScreenShake.ShakeDur.MED, true);
                        CardCrawlGame.sound.play("BLUNT_HEAVY");
                        AbstractDungeon.player.maxHealth -= 10;
                        AbstractDungeon.player.damage(new DamageInfo(null, AbstractDungeon.player.currentHealth - 1));
                        if (AbstractDungeon.player.maxHealth < 1) {
                            AbstractDungeon.player.maxHealth = 1;
                        }
                        AbstractDungeon.player.heal(AbstractDungeon.player.maxHealth);
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                    case 1: {
                        this.logMetric("Gave Idol");
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[2]);
                        this.screenNum = 1;
                        AbstractDungeon.player.loseRelic("Golden Idol");
                        AbstractDungeon.effectList.add(new RainingGoldEffect(333));
                        AbstractDungeon.player.gainGold(333);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                }
                this.logMetric("Ignored");
                GenericEventDialog.updateBodyText(DESCRIPTIONS[3]);
                this.screenNum = 1;
                GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                GenericEventDialog.clearRemainingOptions();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

