/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebeyond;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MonsterHelper;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.AbstractRoom;

public class MysteriousSphere
extends AbstractEvent {
    public static final String ID = "Mysterious Sphere";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Mysterious Sphere");
    public static final String NAME = MysteriousSphere.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = MysteriousSphere.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = MysteriousSphere.eventStrings.OPTIONS;
    public static final String COMBAT_NAME = "SPHERE_COMBAT";
    private static final String INTRO_MSG = DESCRIPTIONS[0];
    private CurScreen screen = CurScreen.INTRO;

    public MysteriousSphere() {
        this.initializeImage("images/events/sphereClosed.png", 1120.0f * Settings.scale, AbstractDungeon.floorY - 50.0f * Settings.scale);
        this.body = INTRO_MSG;
        RoomEventDialog.addDialogOption(OPTIONS[0]);
        RoomEventDialog.addDialogOption(OPTIONS[1]);
        this.hasDialog = true;
        this.hasFocus = true;
        AbstractDungeon.getCurrRoom().monsters = MonsterHelper.getMonster(COMBAT_NAME);
    }

    @Override
    public void update() {
        super.update();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    private void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        this.screen = CurScreen.PRE_COMBAT;
                        RoomEventDialog.updateBodyText(DESCRIPTIONS[1]);
                        RoomEventDialog.updateDialogOption(0, OPTIONS[2]);
                        RoomEventDialog.clearRemainingOptions();
                        this.logMetric("Fight");
                        return;
                    }
                    case 1: {
                        this.screen = CurScreen.END;
                        RoomEventDialog.updateBodyText(DESCRIPTIONS[2]);
                        RoomEventDialog.updateDialogOption(0, OPTIONS[1]);
                        RoomEventDialog.clearRemainingOptions();
                        this.logMetric("Ignore");
                        return;
                    }
                }
                break;
            }
            case PRE_COMBAT: {
                if (Settings.isDailyRun) {
                    AbstractDungeon.getCurrRoom().addGoldToRewards(MathUtils.random(50));
                } else {
                    AbstractDungeon.getCurrRoom().addGoldToRewards(MathUtils.random(45, 55));
                }
                AbstractDungeon.getCurrRoom().addRelicToRewards(AbstractDungeon.returnRandomScreenlessRelic(AbstractRelic.RelicTier.RARE));
                AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMBAT;
                AbstractDungeon.lastCombatMetricKey = NAME;
                AbstractDungeon.getCurrRoom().monsters.init();
                AbstractRoom.waitTimer = 0.1f;
                AbstractDungeon.player.preBattlePrep();
                this.img = ImageMaster.loadImage("images/events/sphereOpen.png");
                this.hasFocus = false;
                AbstractDungeon.dialog.hide();
                break;
            }
            case END: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        PRE_COMBAT,
        END;

    }
}

