/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebottom;

import com.megacrit.cardcrawl.cards.curses.Doubt;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.RainingGoldEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class LiarGameSerpent
extends AbstractImageEvent {
    public static final String ID = "Liars Game";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Liars Game");
    public static final String NAME = LiarGameSerpent.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = LiarGameSerpent.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = LiarGameSerpent.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String AGREE_DIALOG = DESCRIPTIONS[1];
    private static final String DISAGREE_DIALOG = DESCRIPTIONS[2];
    private static final String GOLD_RAIN_MSG = DESCRIPTIONS[3];
    private CUR_SCREEN screen = CUR_SCREEN.INTRO;
    private static final int GOLD_REWARD = 175;

    public LiarGameSerpent() {
        super(NAME, DIALOG_1, "images/events/liarsGame.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0] + 175 + OPTIONS[1], CardLibrary.getCopy("Doubt"));
        GenericEventDialog.setDialogOption(OPTIONS[2]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                if (buttonPressed == 0) {
                    GenericEventDialog.updateBodyText(AGREE_DIALOG);
                    GenericEventDialog.removeDialogOption(1);
                    GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                    this.screen = CUR_SCREEN.AGREE;
                    this.logMetric(true);
                    break;
                }
                GenericEventDialog.updateBodyText(DISAGREE_DIALOG);
                GenericEventDialog.removeDialogOption(1);
                GenericEventDialog.updateDialogOption(0, OPTIONS[4]);
                this.screen = CUR_SCREEN.DISAGREE;
                this.logMetric(false);
                break;
            }
            case AGREE: {
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Doubt(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                UnlockTracker.markCardAsSeen("Doubt");
                AbstractDungeon.effectList.add(new RainingGoldEffect(175));
                AbstractDungeon.player.gainGold(175);
                GenericEventDialog.updateBodyText(GOLD_RAIN_MSG);
                GenericEventDialog.updateDialogOption(0, OPTIONS[4]);
                this.screen = CUR_SCREEN.COMPLETE;
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(boolean agreed) {
        String actionTaken = "agreed";
        if (!agreed) {
            actionTaken = "disagreed";
        }
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CUR_SCREEN {
        INTRO,
        AGREE,
        DISAGREE,
        COMPLETE;

    }
}

