/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebottom;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapOoze
extends AbstractImageEvent {
    private static final Logger logger = LogManager.getLogger(ScrapOoze.class.getName());
    public static final String ID = "Scrap Ooze";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Scrap Ooze");
    public static final String NAME = ScrapOoze.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = ScrapOoze.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = ScrapOoze.eventStrings.OPTIONS;
    private int relicObtainChance = 25;
    private int DAMAGE = 3;
    private int totalDamageDealt = 0;
    private int screenNum = 0;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String FAIL_MSG = DESCRIPTIONS[1];
    private static final String SUCCESS_MSG = DESCRIPTIONS[2];
    private static final String ESCAPE_MSG = DESCRIPTIONS[3];

    public ScrapOoze() {
        super(NAME, DIALOG_1, "images/events/scrapOoze.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0] + this.DAMAGE + OPTIONS[1] + this.relicObtainChance + OPTIONS[2]);
        GenericEventDialog.setDialogOption(OPTIONS[3]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        AbstractDungeon.player.damage(new DamageInfo(null, this.DAMAGE));
                        CardCrawlGame.sound.play("ATTACK_POISON");
                        this.totalDamageDealt += this.DAMAGE;
                        int random = MathUtils.random(0, 99);
                        if (random >= 99 - this.relicObtainChance) {
                            GenericEventDialog.updateBodyText(SUCCESS_MSG);
                            this.logMetric(true, this.totalDamageDealt);
                            GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                            GenericEventDialog.removeDialogOption(1);
                            this.screenNum = 1;
                            AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, AbstractDungeon.returnRandomScreenlessRelic(AbstractDungeon.returnRandomRelicTier()));
                            break block0;
                        }
                        GenericEventDialog.updateBodyText(FAIL_MSG);
                        this.relicObtainChance += 10;
                        ++this.DAMAGE;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[4] + this.DAMAGE + OPTIONS[1] + this.relicObtainChance + OPTIONS[2]);
                        GenericEventDialog.updateDialogOption(1, OPTIONS[3]);
                        break block0;
                    }
                    case 1: {
                        this.logMetric(false, this.totalDamageDealt);
                        GenericEventDialog.updateBodyText(ESCAPE_MSG);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                        GenericEventDialog.removeDialogOption(1);
                        this.screenNum = 1;
                        break block0;
                    }
                }
                logger.info("ERROR: case " + buttonPressed + " should never be called");
                break;
            }
            case 1: {
                this.openMap();
            }
        }
    }

    public void logMetric(boolean success, int damageTaken) {
        String actionTaken = "success";
        if (!success) {
            actionTaken = "unsuccessful";
        }
        AbstractEvent.logMetric(ID, actionTaken, damageTaken);
    }
}

