/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.PotionHelper;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.ui.panels.TopPanel;
import com.megacrit.cardcrawl.vfx.RainingGoldEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KnowingSkull
extends AbstractImageEvent {
    private static final Logger logger = LogManager.getLogger(KnowingSkull.class.getName());
    public static final String ID = "Knowing Skull";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Knowing Skull");
    public static final String NAME = KnowingSkull.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = KnowingSkull.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = KnowingSkull.eventStrings.OPTIONS;
    private static final String INTRO_MSG = DESCRIPTIONS[0];
    private static final String INTRO_2_MSG = DESCRIPTIONS[1];
    private static final String ASK_AGAIN_MSG = DESCRIPTIONS[2];
    private static final String POTION_MSG = DESCRIPTIONS[4];
    private static final String CARD_MSG = DESCRIPTIONS[5];
    private static final String GOLD_MSG = DESCRIPTIONS[6];
    private static final String LEAVE_MSG = DESCRIPTIONS[7];
    private int hpCost;
    private static final int GOLD_REWARD = 90;
    private CurScreen screen = CurScreen.INTRO_1;
    private Reward rewardSlot0 = null;
    private Reward rewardSlot1 = null;
    private int damageDealt = 0;
    private ArrayList<Reward> options = new ArrayList();

    public KnowingSkull() {
        super(NAME, INTRO_MSG, "images/events/knowingSkull.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        this.options.add(Reward.CARD);
        this.options.add(Reward.GOLD);
        this.options.add(Reward.POTION);
        Collections.shuffle(this.options);
        this.damageDealt = 0;
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                this.hpCost = 8;
                break;
            }
            case THE_SILENT: {
                this.hpCost = 7;
                break;
            }
            case CROWBOT: {
                this.hpCost = 8;
                break;
            }
        }
    }

    private Reward setOption(int slot) {
        if (!this.options.isEmpty()) {
            Reward r = this.options.remove(this.options.size() - 1);
            switch (r) {
                case CARD: {
                    GenericEventDialog.updateDialogOption(slot, OPTIONS[3] + this.hpCost + OPTIONS[1]);
                    break;
                }
                case POTION: {
                    GenericEventDialog.updateDialogOption(slot, OPTIONS[4] + this.hpCost + OPTIONS[1]);
                    break;
                }
                case GOLD: {
                    GenericEventDialog.updateDialogOption(slot, OPTIONS[5] + 90 + OPTIONS[6] + this.hpCost + OPTIONS[1]);
                    break;
                }
                default: {
                    logger.info("ERROR!!!");
                }
            }
            return r;
        }
        return null;
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screen) {
            case INTRO_1: {
                GenericEventDialog.updateBodyText(INTRO_2_MSG);
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption("PLACEHOLDER");
                GenericEventDialog.setDialogOption("PLACEHOLDER");
                this.rewardSlot0 = this.setOption(0);
                this.rewardSlot1 = this.setOption(1);
                GenericEventDialog.setDialogOption(OPTIONS[7] + this.hpCost + OPTIONS[1]);
                this.screen = CurScreen.ASK;
                break;
            }
            case ASK: {
                AbstractDungeon.player.damage(new DamageInfo(null, this.hpCost, DamageInfo.DamageType.HP_LOSS));
                CardCrawlGame.sound.play("DEBUFF_2");
                this.damageDealt += this.hpCost;
                switch (buttonPressed) {
                    case 0: {
                        if (this.rewardSlot0 == null) {
                            this.setLeave();
                            break block0;
                        }
                        this.obtainReward(this.rewardSlot0, 0);
                        break block0;
                    }
                    case 1: {
                        if (this.rewardSlot1 == null) {
                            this.setLeave();
                            break block0;
                        }
                        this.obtainReward(this.rewardSlot1, 1);
                        break block0;
                    }
                }
                this.setLeave();
                break;
            }
            case COMPLETE: {
                this.logMetric(this.damageDealt);
                this.openMap();
            }
        }
    }

    private void obtainReward(Reward reward, int slot) {
        this.options.remove((Object)reward);
        block0 : switch (reward) {
            case POTION: {
                GenericEventDialog.updateBodyText(POTION_MSG + ASK_AGAIN_MSG);
                for (int i = 0; i < AbstractDungeon.player.potions.length; ++i) {
                    if (!(AbstractDungeon.player.potions[i] instanceof PotionPlaceholder)) continue;
                    AbstractDungeon.player.potions[i] = PotionHelper.getRandomPotion();
                    AbstractDungeon.player.potions[i].moveInstantly(TopPanel.POTION_X + Settings.POTION_W * (float)i, Settings.POTION_Y);
                    AbstractDungeon.player.potions[i].isDone = true;
                    AbstractDungeon.player.potions[i].isObtained = true;
                    AbstractDungeon.player.potions[i].isAnimating = false;
                    break block0;
                }
                break;
            }
            case GOLD: {
                GenericEventDialog.updateBodyText(GOLD_MSG + ASK_AGAIN_MSG);
                AbstractDungeon.effectList.add(new RainingGoldEffect(90));
                AbstractDungeon.player.gainGold(90);
                break;
            }
            case CARD: {
                GenericEventDialog.updateBodyText(CARD_MSG + ASK_AGAIN_MSG);
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.returnColorlessCard(AbstractCard.CardRarity.UNCOMMON).makeCopy(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                break;
            }
            default: {
                logger.info("This should never happen.");
            }
        }
        if (slot == 0) {
            this.rewardSlot0 = this.setOption(slot);
            if (this.rewardSlot0 == null && this.rewardSlot1 == null) {
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[7] + this.hpCost + OPTIONS[1]);
            } else if (this.rewardSlot0 == null) {
                GenericEventDialog.removeDialogOption(2);
                GenericEventDialog.updateDialogOption(0, OPTIONS[7] + this.hpCost + OPTIONS[1]);
            }
        } else {
            this.rewardSlot1 = this.setOption(slot);
            if (this.rewardSlot0 == null && this.rewardSlot1 == null) {
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[7] + this.hpCost + OPTIONS[1]);
            } else if (this.rewardSlot1 == null) {
                GenericEventDialog.removeDialogOption(2);
                GenericEventDialog.updateDialogOption(1, OPTIONS[7] + this.hpCost + OPTIONS[1]);
            }
        }
    }

    private void setLeave() {
        GenericEventDialog.updateBodyText(LEAVE_MSG);
        GenericEventDialog.clearAllDialogs();
        GenericEventDialog.setDialogOption(OPTIONS[8]);
        this.screen = CurScreen.COMPLETE;
    }

    public void logMetric(int damageTaken) {
        AbstractEvent.logMetric(ID, Integer.toString(damageTaken));
    }

    private static enum Reward {
        POTION,
        LEAVE,
        GOLD,
        CARD;

    }

    private static enum CurScreen {
        INTRO_1,
        ASK,
        COMPLETE;

    }
}

