/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.MonsterHelper;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.relics.RedMask;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.vfx.GainPennyEffect;

public class MaskedBandits
extends AbstractEvent {
    public static final String ID = "Masked Bandits";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Masked Bandits");
    public static final String NAME = MaskedBandits.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = MaskedBandits.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = MaskedBandits.eventStrings.OPTIONS;
    private static final String PAID_MSG_1 = DESCRIPTIONS[0];
    private static final String PAID_MSG_2 = DESCRIPTIONS[1];
    private static final String PAID_MSG_3 = DESCRIPTIONS[2];
    private static final String PAID_MSG_4 = DESCRIPTIONS[3];
    private CurScreen screen = CurScreen.INTRO;

    public MaskedBandits() {
        this.body = DESCRIPTIONS[4];
        RoomEventDialog.addDialogOption(OPTIONS[0]);
        RoomEventDialog.addDialogOption(OPTIONS[1]);
        this.hasDialog = true;
        this.hasFocus = true;
        AbstractDungeon.getCurrRoom().monsters = MonsterHelper.getMonster("The Red Mask Bandits");
    }

    @Override
    public void update() {
        super.update();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    private void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        if (Settings.UPLOAD_DATA) {
                            this.logMetric("Paid Bandits " + AbstractDungeon.player.gold + " gold");
                        }
                        this.stealGold();
                        AbstractDungeon.player.loseGold(AbstractDungeon.player.gold);
                        RoomEventDialog.updateBodyText(PAID_MSG_1);
                        RoomEventDialog.updateDialogOption(0, OPTIONS[2]);
                        RoomEventDialog.clearRemainingOptions();
                        this.screen = CurScreen.PAID_1;
                        return;
                    }
                    case 1: {
                        if (Settings.UPLOAD_DATA) {
                            this.logMetric("Fought over " + AbstractDungeon.player.gold + " gold");
                        }
                        if (Settings.isDailyRun) {
                            AbstractDungeon.getCurrRoom().addGoldToRewards(MathUtils.random(30));
                        } else {
                            AbstractDungeon.getCurrRoom().addGoldToRewards(MathUtils.random(25, 35));
                        }
                        AbstractDungeon.getCurrRoom().addRelicToRewards(new RedMask());
                        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMBAT;
                        AbstractDungeon.lastCombatMetricKey = NAME;
                        AbstractDungeon.getCurrRoom().monsters.init();
                        AbstractRoom.waitTimer = 0.1f;
                        AbstractDungeon.player.preBattlePrep();
                        this.hasFocus = false;
                        AbstractDungeon.dialog.hide();
                        return;
                    }
                }
                break;
            }
            case PAID_1: {
                RoomEventDialog.updateBodyText(PAID_MSG_2);
                this.screen = CurScreen.PAID_2;
                RoomEventDialog.updateDialogOption(0, OPTIONS[2]);
                break;
            }
            case PAID_2: {
                RoomEventDialog.updateBodyText(PAID_MSG_3);
                this.screen = CurScreen.PAID_3;
                RoomEventDialog.updateDialogOption(0, OPTIONS[3]);
                break;
            }
            case PAID_3: {
                RoomEventDialog.updateBodyText(PAID_MSG_4);
                RoomEventDialog.updateDialogOption(0, OPTIONS[3]);
                this.screen = CurScreen.END;
                this.openMap();
                break;
            }
            case END: {
                this.openMap();
            }
        }
    }

    private void stealGold() {
        AbstractPlayer target = AbstractDungeon.player;
        if (target.gold == 0) {
            return;
        }
        CardCrawlGame.sound.play("GOLD_JINGLE");
        for (int i = 0; i < target.gold; ++i) {
            AbstractMonster source = AbstractDungeon.getCurrRoom().monsters.getRandomMonster();
            AbstractDungeon.effectList.add(new GainPennyEffect(source, target.hb.cX, target.hb.cY, source.hb.cX, source.hb.cY, false));
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        PAID_1,
        PAID_2,
        PAID_3,
        END;

    }
}

