/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import java.util.ArrayList;

public class TheLibrary
extends AbstractImageEvent {
    public static final String ID = "The Library";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("The Library");
    public static final String NAME = TheLibrary.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = TheLibrary.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = TheLibrary.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String SLEEP_RESULT = DESCRIPTIONS[1];
    private int screenNum = 0;
    private boolean pickCard = false;

    public TheLibrary() {
        super(NAME, DIALOG_1, "images/events/library.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        GenericEventDialog.setDialogOption(OPTIONS[1] + AbstractDungeon.player.maxHealth / 3 + OPTIONS[2]);
    }

    @Override
    public void update() {
        super.update();
        if (this.pickCard && !AbstractDungeon.isScreenUp && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.gridSelectScreen.selectedCards.get(0).makeCopy(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.updateBodyText(this.getBook());
                        this.logMetric("Read");
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                        GenericEventDialog.clearRemainingOptions();
                        this.pickCard = true;
                        CardGroup group = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
                        AbstractCard card = null;
                        for (int i = 0; i < 20; ++i) {
                            card = AbstractDungeon.getCardWithoutRng(AbstractDungeon.rollRarity());
                            if (!group.contains(card)) {
                                group.addToBottom(card);
                                continue;
                            }
                            --i;
                        }
                        for (AbstractCard c : group.group) {
                            UnlockTracker.markCardAsSeen(c.cardID);
                        }
                        AbstractDungeon.gridSelectScreen.open(group, 1, OPTIONS[4], false);
                        break block0;
                    }
                }
                GenericEventDialog.updateBodyText(SLEEP_RESULT);
                AbstractDungeon.player.heal(AbstractDungeon.player.maxHealth / 3, true);
                this.logMetric("Heal");
                this.screenNum = 1;
                GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                GenericEventDialog.clearRemainingOptions();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    private String getBook() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DESCRIPTIONS[2]);
        list.add(DESCRIPTIONS[3]);
        list.add(DESCRIPTIONS[4]);
        return (String)list.get(MathUtils.random(2));
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

