/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.gashapon;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.gashapon.GashaponRoom;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.PotionHelper;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Gashapon {
    private static final Logger logger = LogManager.getLogger(Gashapon.class.getName());
    public Hitbox hb = new Hitbox(240.0f * Settings.scale, 240.0f * Settings.scale);
    public static final int W = 256;
    private boolean used = false;
    private GashaponRoom.GashaContent content;

    public Gashapon(int slot, GashaponRoom.GashaContent content) {
        switch (slot) {
            case 0: {
                this.hb.move((float)Settings.WIDTH * 0.25f, AbstractDungeon.floorY + 128.0f * Settings.scale);
                break;
            }
            case 1: {
                this.hb.move((float)Settings.WIDTH * 0.5f, AbstractDungeon.floorY + 128.0f * Settings.scale);
                break;
            }
            default: {
                this.hb.move((float)Settings.WIDTH * 0.75f, AbstractDungeon.floorY + 128.0f * Settings.scale);
            }
        }
        this.content = content;
    }

    public void update() {
        if (!this.used) {
            this.hb.update();
        }
        if (this.hb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
        if (this.hb.hovered && InputHelper.justClickedLeft) {
            this.hb.clickStarted = true;
        }
        if (this.hb.clicked) {
            this.getContents();
            this.hb.clicked = false;
            this.hb.hovered = false;
            this.used = true;
            CardCrawlGame.sound.play("UI_CLICK_2");
            logger.info("Boop");
        }
    }

    private void getContents() {
        block0 : switch (this.content) {
            case CARD: {
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.COMMON), this.hb.cX, this.hb.cY + 150.0f * Settings.scale));
                break;
            }
            case GOLD: {
                CardCrawlGame.sound.play("GOLD_JINGLE");
                AbstractDungeon.player.gainGold(MathUtils.random(25, 99));
                break;
            }
            case HP: {
                AbstractDungeon.player.increaseMaxHp(MathUtils.random(3, 10), false);
                break;
            }
            case POTION: {
                AbstractPotion potion = PotionHelper.getRandomPotion();
                for (int i = 0; i < 3; ++i) {
                    if (!(AbstractDungeon.player.potions[i] instanceof PotionPlaceholder)) continue;
                    CardCrawlGame.sound.play("POTION_1");
                    potion.moveInstantly(AbstractDungeon.player.potions[i].currentX, AbstractDungeon.player.potions[i].currentY);
                    potion.isObtained = true;
                    potion.isDone = true;
                    potion.isAnimating = false;
                    potion.flash();
                    AbstractDungeon.player.potions[i] = potion;
                    break block0;
                }
                break;
            }
            case RELIC: {
                AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, AbstractDungeon.returnRandomRelic(AbstractRelic.RelicTier.COMMON));
                break;
            }
            case UNLOCK_RELIC: {
                if (!UnlockTracker.lockedRelics.isEmpty()) break;
                logger.info("ALL RELICS ARE UNLOCKED.");
                this.content = GashaponRoom.GashaContent.RELIC;
                this.getContents();
                break;
            }
            case UNLOCK_CARD: {
                if (!UnlockTracker.lockedCards.isEmpty()) break;
                logger.info("ALL CARD ARE UNLOCKED.");
                this.content = GashaponRoom.GashaContent.CARD;
                this.getContents();
                break;
            }
        }
    }

    public void render(SpriteBatch sb) {
        if (this.used) {
            sb.setColor(Color.RED);
        } else {
            sb.setColor(Color.WHITE);
        }
        this.hb.render(sb);
    }

    public static enum GashaReward {
        HP,
        GOLD,
        POTION,
        RELIC,
        CARD;

    }
}

