/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.shrines.AccursedBlacksmith;
import com.megacrit.cardcrawl.events.shrines.Bonfire;
import com.megacrit.cardcrawl.events.shrines.DemonMatchGame;
import com.megacrit.cardcrawl.events.shrines.Duplicator;
import com.megacrit.cardcrawl.events.shrines.FountainOfCurseRemoval;
import com.megacrit.cardcrawl.events.shrines.GoldShrine;
import com.megacrit.cardcrawl.events.shrines.Lab;
import com.megacrit.cardcrawl.events.shrines.PurificationShrine;
import com.megacrit.cardcrawl.events.shrines.Transmorgrifier;
import com.megacrit.cardcrawl.events.shrines.UpgradeShrine;
import com.megacrit.cardcrawl.events.shrines.WheelOfChange;
import com.megacrit.cardcrawl.events.shrines.WomanInBlue;
import com.megacrit.cardcrawl.events.thebeyond.Falling;
import com.megacrit.cardcrawl.events.thebeyond.MoaiHead;
import com.megacrit.cardcrawl.events.thebeyond.MysteriousSphere;
import com.megacrit.cardcrawl.events.thebeyond.TombRedMask;
import com.megacrit.cardcrawl.events.thebeyond.WindingHalls;
import com.megacrit.cardcrawl.events.thebottom.BigFish;
import com.megacrit.cardcrawl.events.thebottom.Cleric;
import com.megacrit.cardcrawl.events.thebottom.DeadAdventurer;
import com.megacrit.cardcrawl.events.thebottom.GoldenIdolEvent;
import com.megacrit.cardcrawl.events.thebottom.GoldenWing;
import com.megacrit.cardcrawl.events.thebottom.GoopPuddle2;
import com.megacrit.cardcrawl.events.thebottom.LiarGameSerpent;
import com.megacrit.cardcrawl.events.thebottom.LivingWall;
import com.megacrit.cardcrawl.events.thebottom.Mushrooms;
import com.megacrit.cardcrawl.events.thebottom.Nloth;
import com.megacrit.cardcrawl.events.thebottom.ScrapOoze;
import com.megacrit.cardcrawl.events.thebottom.ShiningLight;
import com.megacrit.cardcrawl.events.thecity.Addict;
import com.megacrit.cardcrawl.events.thecity.BackToBasics;
import com.megacrit.cardcrawl.events.thecity.Beggar;
import com.megacrit.cardcrawl.events.thecity.CursedTome;
import com.megacrit.cardcrawl.events.thecity.DrugDealer;
import com.megacrit.cardcrawl.events.thecity.ForgottenAltar;
import com.megacrit.cardcrawl.events.thecity.KnowingSkull;
import com.megacrit.cardcrawl.events.thecity.MaskedBandits;
import com.megacrit.cardcrawl.events.thecity.TheJoust;
import com.megacrit.cardcrawl.events.thecity.TheLibrary;
import com.megacrit.cardcrawl.events.thecity.TheMausoleum;
import com.megacrit.cardcrawl.events.thecity.Vampires;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventHelper {
    private static final Logger logger = LogManager.getLogger(EventHelper.class.getName());
    private static final float BASE_ELITE_CHANCE = 0.02f;
    private static final float BASE_MONSTER_CHANCE = 0.1f;
    private static final float BASE_SHOP_CHANCE = 0.03f;
    private static final float BASE_TREASURE_CHANCE = 0.02f;
    private static final float RAMP_ELITE_CHANCE = 0.02f;
    private static final float RAMP_MONSTER_CHANCE = 0.1f;
    private static final float RAMP_SHOP_CHANCE = 0.03f;
    private static final float RAMP_TREASURE_CHANCE = 0.02f;
    private static final float RESET_ELITE_CHANCE = 0.0f;
    private static final float RESET_MONSTER_CHANCE = 0.1f;
    private static final float RESET_SHOP_CHANCE = 0.03f;
    private static final float RESET_TREASURE_CHANCE = 0.02f;
    private static float ELITE_CHANCE = 0.02f;
    private static float MONSTER_CHANCE = 0.1f;
    private static float SHOP_CHANCE = 0.03f;
    public static float TREASURE_CHANCE = 0.02f;

    public static RoomResult roll() {
        float roll = AbstractDungeon.eventRng.random();
        logger.info("ROLL: " + roll);
        logger.info("ELIT: " + ELITE_CHANCE);
        logger.info("MNST: " + MONSTER_CHANCE);
        logger.info("SHOP: " + SHOP_CHANCE);
        logger.info("TRSR: " + TREASURE_CHANCE);
        RoomResult[] possibleResults = new RoomResult[100];
        Arrays.fill((Object[])possibleResults, (Object)RoomResult.EVENT);
        int eliteSize = (int)(ELITE_CHANCE * 100.0f);
        if (AbstractDungeon.getCurrMapNode().y < 6) {
            eliteSize = 0;
        }
        int monsterSize = (int)(MONSTER_CHANCE * 100.0f);
        int shopSize = (int)(SHOP_CHANCE * 100.0f);
        int treasureSize = (int)(TREASURE_CHANCE * 100.0f);
        if (AbstractDungeon.player.hasRelic("Tiny Chest")) {
            treasureSize += 10;
        }
        int fillIndex = 0;
        Arrays.fill((Object[])possibleResults, Math.min(99, fillIndex), Math.min(100, fillIndex + eliteSize), (Object)RoomResult.ELITE);
        Arrays.fill((Object[])possibleResults, Math.min(99, fillIndex += eliteSize), Math.min(100, fillIndex + monsterSize), (Object)RoomResult.MONSTER);
        Arrays.fill((Object[])possibleResults, Math.min(99, fillIndex += monsterSize), Math.min(100, fillIndex + shopSize), (Object)RoomResult.SHOP);
        Arrays.fill((Object[])possibleResults, Math.min(99, fillIndex += shopSize), Math.min(100, fillIndex + treasureSize), (Object)RoomResult.TREASURE);
        RoomResult choice = possibleResults[(int)(roll * 100.0f)];
        if (choice == RoomResult.ELITE) {
            if (AbstractDungeon.player.hasRelic("Juzu Bracelet")) {
                AbstractDungeon.player.getRelic("Juzu Bracelet").flash();
                choice = RoomResult.EVENT;
            }
            ELITE_CHANCE = 0.0f;
        } else {
            ELITE_CHANCE += 0.02f;
        }
        if (choice == RoomResult.MONSTER) {
            if (AbstractDungeon.player.hasRelic("Juzu Bracelet")) {
                AbstractDungeon.player.getRelic("Juzu Bracelet").flash();
                choice = RoomResult.EVENT;
            }
            MONSTER_CHANCE = 0.1f;
        } else {
            MONSTER_CHANCE += 0.1f;
        }
        SHOP_CHANCE = choice == RoomResult.SHOP ? 0.03f : (SHOP_CHANCE += 0.03f);
        if (choice == RoomResult.TREASURE) {
            if (AbstractDungeon.player.hasRelic("Tiny Chest")) {
                AbstractDungeon.player.getRelic("Tiny Chest").flash();
            }
            TREASURE_CHANCE = 0.02f;
        } else {
            TREASURE_CHANCE += 0.02f;
        }
        return choice;
    }

    public static void resetProbabilities() {
        ELITE_CHANCE = 0.0f;
        MONSTER_CHANCE = 0.1f;
        SHOP_CHANCE = 0.03f;
        TREASURE_CHANCE = AbstractDungeon.player.hasRelic("Tiny Chest") ? 0.120000005f : 0.02f;
    }

    public static void setChances(ArrayList<Float> chances) {
        ELITE_CHANCE = chances.get(0).floatValue();
        MONSTER_CHANCE = chances.get(1).floatValue();
        SHOP_CHANCE = chances.get(2).floatValue();
        TREASURE_CHANCE = chances.get(3).floatValue();
    }

    public static ArrayList<Float> getChances() {
        ArrayList<Float> chances = new ArrayList<Float>();
        chances.add(Float.valueOf(ELITE_CHANCE));
        chances.add(Float.valueOf(MONSTER_CHANCE));
        chances.add(Float.valueOf(SHOP_CHANCE));
        chances.add(Float.valueOf(TREASURE_CHANCE));
        return chances;
    }

    public static AbstractEvent getEvent(String key) {
        switch (key) {
            case "Accursed Blacksmith": {
                return new AccursedBlacksmith();
            }
            case "Bonfire Elementals": {
                return new Bonfire();
            }
            case "Fountain of Cleansing": {
                return new FountainOfCurseRemoval();
            }
            case "Duplicator": {
                return new Duplicator();
            }
            case "Lab": {
                return new Lab();
            }
            case "Match and Keep!": {
                return new DemonMatchGame();
            }
            case "Golden Shrine": {
                return new GoldShrine();
            }
            case "Purifier": {
                return new PurificationShrine();
            }
            case "Transmorgrifier": {
                return new Transmorgrifier();
            }
            case "Wheel of Change": {
                return new WheelOfChange();
            }
            case "Upgrade Shrine": {
                return new UpgradeShrine();
            }
            case "Big Fish": {
                return new BigFish();
            }
            case "The Cleric": {
                return new Cleric();
            }
            case "Dead Adventurer": {
                return new DeadAdventurer();
            }
            case "Golden Wing": {
                return new GoldenWing();
            }
            case "Golden Idol": {
                return new GoldenIdolEvent();
            }
            case "World of Goop": {
                return new GoopPuddle2();
            }
            case "Forgotten Altar": {
                return new ForgottenAltar();
            }
            case "Scrap Ooze": {
                return new ScrapOoze();
            }
            case "Liars Game": {
                return new LiarGameSerpent();
            }
            case "Living Wall": {
                return new LivingWall();
            }
            case "Mushrooms": {
                return new Mushrooms();
            }
            case "N'loth": {
                return new Nloth();
            }
            case "Shining Light": {
                return new ShiningLight();
            }
            case "Vampires": {
                return new Vampires();
            }
            case "Addict": {
                return new Addict();
            }
            case "Back to Basics": {
                return new BackToBasics();
            }
            case "Beggar": {
                return new Beggar();
            }
            case "Cursed Tome": {
                return new CursedTome();
            }
            case "Drug Dealer": {
                return new DrugDealer();
            }
            case "Knowing Skull": {
                return new KnowingSkull();
            }
            case "Masked Bandits": {
                return new MaskedBandits();
            }
            case "The Library": {
                return new TheLibrary();
            }
            case "The Mausoleum": {
                return new TheMausoleum();
            }
            case "The Joust": {
                return new TheJoust();
            }
            case "The Woman in Blue": {
                return new WomanInBlue();
            }
            case "Mysterious Sphere": {
                return new MysteriousSphere();
            }
            case "Tomb of Lord Red Mask": {
                return new TombRedMask();
            }
            case "Falling": {
                return new Falling();
            }
            case "Winding Halls": {
                return new WindingHalls();
            }
            case "The Moai Head": {
                return new MoaiHead();
            }
        }
        logger.info("---------------------------\nERROR: Unspecified key: " + key + " in EventHelper.\n---------------------------");
        return null;
    }

    public static enum RoomResult {
        EVENT,
        ELITE,
        TREASURE,
        SHOP,
        MONSTER;

    }
}

