/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FontHelper {
    private static final Logger logger = LogManager.getLogger(FontHelper.class.getName());
    private static FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter();
    private static FreeTypeFontGenerator generator;
    private static final String CHAR_SET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_/\\()[]:;~`<>&*,.%$+-=!?'\"";
    private static final String NUM_CHAR_SET = "X+-0123456789/";
    public static BitmapFont kreon_32_special;
    private static final float CHAR_DESC_SIZE = 28.0f;
    private static final float CHAR_TITLE_SIZE = 44.0f;
    public static BitmapFont charDescFont;
    public static BitmapFont charTitleFont;
    private static final float CARD_ENERGY_SIZE = 38.0f;
    private static final float CARD_TITLE_SIZE = 27.0f;
    private static final float CARD_TITLE_SMALL_SIZE = 23.0f;
    private static final float CARD_TYPE_SIZE = 17.0f;
    private static final float CARD_DESC_SIZE = 24.0f;
    private static final float CARD_DESC_SMALL_SIZE = 20.0f;
    private static final float DECK_COUNT_SIZE = 30.0f;
    public static BitmapFont cardTitleFont_L;
    public static BitmapFont cardTitleFont_small_L;
    public static BitmapFont cardTitleFont_N;
    public static BitmapFont cardTitleFont_small_N;
    public static BitmapFont cardTypeFont_N;
    public static BitmapFont cardTypeFont_L;
    public static BitmapFont cardEnergyFont_L;
    public static BitmapFont cardDescFont_N;
    public static BitmapFont cardDescFont_small_N;
    public static BitmapFont cardDescFont_L;
    public static BitmapFont cardDescFont_small_L;
    public static BitmapFont deckCountFont;
    public static BitmapFont SCP_cardDescFont;
    public static BitmapFont SCP_cardDescFont_small;
    public static BitmapFont SCP_cardEnergyFont;
    public static BitmapFont SCP_cardTitleFont;
    public static BitmapFont SCP_cardTitleFont_small;
    public static BitmapFont SCP_cardTypeFont;
    public static BitmapFont SRV_quoteFont;
    private static final float APPLY_POWER_SIZE = 44.0f;
    public static BitmapFont applyPowerFont;
    private static final float LOSE_POWER_SIZE = 36.0f;
    public static BitmapFont losePowerFont;
    private static final float ENERGY_NUM_SIZE = 36.0f;
    public static BitmapFont energyNumFontRed;
    public static BitmapFont energyNumFontGreen;
    private static final float MAP_LEGEND_BODY = 26.0f;
    private static final float MAP_LEGEND_HEADER = 36.0f;
    public static BitmapFont mapLegendBodyFont;
    public static BitmapFont mapLegendHeaderFont;
    public static BitmapFont levelTransitionFont;
    private static final float TURN_NUM = 32.0f;
    public static BitmapFont turnNumFont;
    private static final float DAMAGE_NUM = 48.0f;
    public static BitmapFont damageNumberFont;
    private static final float TEXT_ABOVE_ENEMY_EFFECT = 32.0f;
    public static BitmapFont textAboveEnemyFont;
    private static final float BANNER_FONT_SIZE = 40.0f;
    public static BitmapFont bannerFont;
    private static final float BUTTON_LABEL_SIZE = 30.0f;
    public static BitmapFont buttonLabelFont;
    private static final float MENU_BUTTON_SIZE = 40.0f;
    public static BitmapFont menuButtonFont;
    private static final float CARD_ENERGY_IMG_WIDTH;
    private static final float TRANSITION_TITLE_SIZE = 144.0f;
    public static BitmapFont dungeonTitleFont;
    private static final float CHAR_SELECT_NAME_SIZE = 72.0f;
    public static BitmapFont bannerNameFont;
    private static final float TOP_PANEL_AMT_SIZE = 24.0f;
    public static BitmapFont topPanelAmountFont;
    private static final float POWER_AMT_SIZE2 = 16.0f;
    public static BitmapFont powerAmountFont2;
    public static BitmapFont rewardTipFont;
    private static final float PANEL_NAME_SIZE = 34.0f;
    private static final float PANEL_INFO_SIZE = 22.0f;
    private static final float HEALTH_INFO_SIZE = 22.0f;
    private static final float BLOCK_INFO_SIZE = 24.0f;
    private static final float NAME_TITLE_SCALE = 0.66f;
    private static final float KEY_GOLD_SIZE = 26.0f;
    public static BitmapFont panelNameFont;
    public static BitmapFont panelInfoFont;
    public static BitmapFont healthInfoFont;
    public static BitmapFont blockInfoFont;
    public static BitmapFont panelNameTitleFont;
    public static BitmapFont topPanelInfoFont;
    private static final float TIP_HEADER_SIZE = 23.0f;
    private static final float TIP_BODY_SIZE = 22.0f;
    public static BitmapFont tipHeaderFont;
    public static BitmapFont tipBodyFont;
    private static final float POPUP_LABEL_SIZE = 26.0f;
    public static BitmapFont popupLabelFont;
    private static final float END_TURN_SIZE = 26.0f;
    public static BitmapFont panelEndTurnFont;
    private static final float SPEECH_FONT_SIZE = 30.0f;
    public static BitmapFont speech_font;
    private static final float EVENT_BODY_SIZE = 30.0f;
    public static BitmapFont eventBodyText;
    private static final float DIALOG_FONT_SIZE = 24.0f;
    public static BitmapFont roomEventBody;
    private static final float TEXT_ONLY_EVENT_TITLE = 32.0f;
    public static BitmapFont textOnlyEventTitle;
    private static final float TEXT_ONLY_EVENT_SIZE = 25.0f;
    public static BitmapFont textOnlyEventBody;
    private static final float TEXT_ONLY_EVENT_OPT_SIZE = 25.0f;
    public static BitmapFont textOnlyEventOption;
    private static final float DECK_BANNER_NAME_SIZE = 34.0f;
    public static BitmapFont deckBannerFont;
    private static final float DECK_VIEW_BODY_SIZE = 24.0f;
    public static BitmapFont deckViewBodyFont;
    private static final float CARD_SELECT_SCREEN_FONT_SIZE = 48.0f;
    public static BitmapFont cardSelectMsgFont;
    private static final float SHOP_BUTTON_FONT_SIZE = 28.0f;
    public static BitmapFont shopGoldFont;
    public static final float OPTION_BANNER_SIZE = 40.0f;
    public static final float QUESTION_MARK_POPUP_SIZE = 120.0f;
    public static BitmapFont menuBannerFont;
    public static BitmapFont largeCardFont;
    public static GlyphLayout layout;
    public static Scanner s;
    private static final int TIP_OFFSET_X = 50;
    private static final float TIP_PADDING = 8.0f;

    public static void initialize() {
        long startTime = System.currentTimeMillis();
        FileHandle fontFile = Gdx.files.internal("font/Kreon-Regular.ttf");
        generator = new FreeTypeFontGenerator(fontFile);
        FontHelper.param.characters = CHAR_SET;
        FontHelper.param.minFilter = Texture.TextureFilter.Linear;
        FontHelper.param.magFilter = Texture.TextureFilter.Linear;
        FontHelper.param.hinting = FreeTypeFontGenerator.Hinting.Slight;
        FontHelper.param.spaceX = 0;
        FontHelper.param.kerning = true;
        mapLegendBodyFont = FontHelper.prepFont(26.0f * Settings.scale);
        mapLegendHeaderFont = FontHelper.prepFont(36.0f * Settings.scale);
        FontHelper.param.spaceX = (int)(-4.0f * Settings.scale);
        FontHelper.param.borderWidth = 4.0f * Settings.scale;
        FontHelper.param.borderColor = new Color(0.0f, 0.0f, 0.0f, 0.5f);
        levelTransitionFont = FontHelper.prepFont(48.0f, true);
        FontHelper.param.spaceX = 0;
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.gamma = 0.9f;
        FontHelper.param.borderGamma = 0.9f;
        deckViewBodyFont = FontHelper.prepFont(24.0f * Settings.scale);
        FontHelper.param.gamma = 0.9f;
        FontHelper.param.borderGamma = 0.9f;
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        FontHelper.param.shadowOffsetX = (int)(4.0f * Settings.scale);
        charDescFont = FontHelper.prepFont(28.0f, true);
        FontHelper.param.gamma = 1.8f;
        FontHelper.param.borderGamma = 1.8f;
        FontHelper.param.shadowOffsetX = (int)(6.0f * Settings.scale);
        charTitleFont = FontHelper.prepFont(44.0f, false);
        FontHelper.param.minFilter = Texture.TextureFilter.Nearest;
        FontHelper.param.magFilter = Texture.TextureFilter.MipMapNearestNearest;
        FontHelper.param.gamma = 0.9f;
        FontHelper.param.borderGamma = 0.9f;
        FontHelper.param.borderStraight = true;
        FontHelper.param.shadowOffsetX = Math.round(3.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = Math.round(3.0f * Settings.scale);
        FontHelper.param.borderStraight = false;
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        FontHelper.param.borderColor = new Color(0.35f, 0.35f, 0.35f, 1.0f);
        FontHelper.param.borderWidth = 2.0f * Settings.scale;
        cardTitleFont_N = FontHelper.prepFont(27.0f, true);
        cardTitleFont_L = FontHelper.prepFont(27.0f, true);
        FontHelper.param.borderWidth = 2.25f * Settings.scale;
        cardTitleFont_small_N = FontHelper.prepFont(23.0f, true);
        cardTitleFont_small_L = FontHelper.prepFont(23.0f, true);
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.shadowOffsetX = 1;
        FontHelper.param.shadowOffsetY = 1;
        FontHelper.param.spaceX = 0;
        cardDescFont_N = FontHelper.prepFont(24.0f, false);
        cardDescFont_L = FontHelper.prepFont(24.0f, true);
        cardDescFont_small_N = FontHelper.prepFont(20.0f, false);
        cardDescFont_small_L = FontHelper.prepFont(20.0f, true);
        FontHelper.param.borderWidth = 0.0f;
        deckCountFont = FontHelper.prepFont(30.0f, false);
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        FontHelper.param.shadowOffsetX = Math.round(4.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = Math.round(3.0f * Settings.scale);
        kreon_32_special = FontHelper.prepFont(38.0f, true);
        SCP_cardDescFont = FontHelper.prepFont(48.0f, true);
        FontHelper.SCP_cardDescFont.getData().markupEnabled = true;
        SCP_cardDescFont_small = FontHelper.prepFont(40.0f, true);
        FontHelper.SCP_cardDescFont_small.getData().markupEnabled = true;
        FontHelper.param.shadowOffsetX = Math.round(6.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = Math.round(6.0f * Settings.scale);
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        FontHelper.param.borderColor = new Color(0.35f, 0.35f, 0.35f, 1.0f);
        FontHelper.param.borderWidth = 4.0f * Settings.scale;
        SCP_cardTitleFont = FontHelper.prepFont(54.0f, true);
        SCP_cardTitleFont_small = FontHelper.prepFont(46.0f, true);
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        FontHelper.param.shadowOffsetX = Math.round(3.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = Math.round(3.0f * Settings.scale);
        panelNameFont = FontHelper.prepFont(34.0f * Settings.scale);
        panelNameTitleFont = FontHelper.prepFont(34.0f * Settings.scale * 0.66f);
        FontHelper.param.shadowOffsetX = (int)(3.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(3.0f * Settings.scale);
        FontHelper.param.borderColor = new Color(0.67f, 0.06f, 0.22f, 1.0f);
        FontHelper.param.gamma = 0.9f;
        FontHelper.param.borderGamma = 0.9f;
        FontHelper.param.borderColor = new Color(0.4f, 0.1f, 0.1f, 1.0f);
        FontHelper.param.minFilter = Texture.TextureFilter.Nearest;
        FontHelper.param.magFilter = Texture.TextureFilter.MipMapLinearNearest;
        FontHelper.param.borderWidth = 0.0f;
        panelInfoFont = FontHelper.prepFont(22.0f * Settings.scale);
        tipBodyFont = FontHelper.prepFont(22.0f * Settings.scale);
        textAboveEnemyFont = FontHelper.prepFont(32.0f * Settings.scale);
        popupLabelFont = FontHelper.prepFont(26.0f * Settings.scale);
        FontHelper.param.borderColor = new Color(0.1f, 0.1f, 0.1f, 0.5f);
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.borderWidth = 2.0f * Settings.scale;
        topPanelAmountFont = FontHelper.prepFont(24.0f * Settings.scale);
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.borderColor = Color.valueOf("42514dff");
        FontHelper.param.shadowOffsetX = 0;
        FontHelper.param.shadowOffsetY = 0;
        FontHelper.param.borderWidth = 0.0f;
        rewardTipFont = FontHelper.prepFont(24.0f * Settings.scale);
        FontHelper.param.shadowOffsetX = (int)(3.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(3.0f * Settings.scale);
        FontHelper.param.shadowOffsetX = (int)(4.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(4.0f * Settings.scale);
        FontHelper.param.spaceX = (int)(-2.1f * Settings.scale);
        FontHelper.param.borderWidth = 3.0f * Settings.scale;
        panelEndTurnFont = FontHelper.prepFont(26.0f * Settings.scale);
        FontHelper.param.spaceX = 0;
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.shadowOffsetX = 0;
        FontHelper.param.shadowOffsetY = 0;
        speech_font = FontHelper.prepFont(30.0f, true);
        FontHelper.param.shadowOffsetX = (int)(3.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(3.0f * Settings.scale);
        eventBodyText = FontHelper.prepFont(30.0f, false);
        roomEventBody = FontHelper.prepFont(24.0f * Settings.scale);
        textOnlyEventBody = FontHelper.prepFont(25.0f, true);
        textOnlyEventOption = FontHelper.prepFont(25.0f, true);
        FontHelper.param.shadowOffsetX = 0;
        FontHelper.param.shadowOffsetY = 0;
        cardSelectMsgFont = FontHelper.prepFont(48.0f, true);
        shopGoldFont = FontHelper.prepFont(28.0f, true);
        turnNumFont = FontHelper.prepFont(32.0f, true);
        FontHelper.param.borderWidth = 4.0f * Settings.scale;
        FontHelper.param.borderColor = new Color(0.3f, 0.3f, 0.3f, 1.0f);
        applyPowerFont = FontHelper.prepFont(44.0f, true);
        losePowerFont = FontHelper.prepFont(36.0f, true);
        FontHelper.param.borderWidth = 3.0f * Settings.scale;
        FontHelper.param.borderColor = Color.DARK_GRAY.cpy();
        FontHelper.param.minFilter = Texture.TextureFilter.Linear;
        FontHelper.param.magFilter = Texture.TextureFilter.Linear;
        damageNumberFont = FontHelper.prepFont(48.0f * Settings.scale);
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.shadowOffsetX = (int)(5.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(5.0f * Settings.scale);
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.33f);
        deckBannerFont = FontHelper.prepFont(34.0f * Settings.scale);
        FontHelper.param.borderWidth = 2.7f * Settings.scale;
        FontHelper.param.shadowOffsetX = (int)(3.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(3.0f * Settings.scale);
        FontHelper.param.borderColor = new Color(0.45f, 0.1f, 0.12f, 1.0f);
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        healthInfoFont = FontHelper.prepFont(22.0f, false);
        FontHelper.param.borderColor = new Color(0.408f, 0.361f, 0.321f, 1.0f);
        textOnlyEventTitle = FontHelper.prepFont(32.0f * Settings.scale);
        FontHelper.param.spaceX = (int)(-2.1f * Settings.scale);
        FontHelper.param.borderWidth = 4.0f * Settings.scale;
        FontHelper.param.borderColor = new Color(0.0f, 0.0f, 0.0f, 0.15f);
        buttonLabelFont = FontHelper.prepFont(30.0f, false);
        FontHelper.param.borderWidth = 4.0f * Settings.scale;
        FontHelper.param.spaceX = (int)(-3.1f * Settings.scale);
        FontHelper.param.borderColor = new Color(0.0f, 0.0f, 0.0f, 0.33f);
        menuButtonFont = FontHelper.prepFont(40.0f, true);
        FontHelper.param.spaceX = 0;
        generator.dispose();
        fontFile = Gdx.files.internal("font/Kreon-Bold.ttf");
        generator = new FreeTypeFontGenerator(fontFile);
        FontHelper.param.shadowOffsetX = (int)(2.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(2.0f * Settings.scale);
        FontHelper.param.borderColor = new Color(0.0f, 0.33f, 0.2f, 0.8f);
        FontHelper.param.borderWidth = 2.7f * Settings.scale;
        FontHelper.param.spaceX = (int)(-0.9f * Settings.scale);
        blockInfoFont = FontHelper.prepFont(24.0f, false);
        FontHelper.param.gamma = 1.2f;
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.shadowOffsetX = 0;
        FontHelper.param.shadowOffsetY = 0;
        if (Settings.WIDTH >= 1600) {
            FontHelper.param.spaceX = -1;
        }
        cardTypeFont_N = FontHelper.prepFont(17.0f, false);
        cardTypeFont_L = FontHelper.prepFont(17.0f, true);
        SCP_cardTypeFont = FontHelper.prepFont(34.0f, true);
        FontHelper.param.characters = NUM_CHAR_SET;
        FontHelper.param.borderStraight = true;
        FontHelper.param.borderWidth = 4.0f * Settings.scale;
        FontHelper.param.borderColor = new Color(0.4f, 0.15f, 0.15f, 1.0f);
        energyNumFontRed = FontHelper.prepFont(36.0f, true);
        FontHelper.param.borderColor = new Color(0.15f, 0.4f, 0.15f, 1.0f);
        energyNumFontGreen = FontHelper.prepFont(36.0f, true);
        FontHelper.param.borderWidth = 4.0f * Settings.scale;
        FontHelper.param.borderColor = new Color(0.3f, 0.3f, 0.3f, 1.0f);
        cardEnergyFont_L = FontHelper.prepFont(38.0f, true);
        FontHelper.param.borderWidth = 8.0f * Settings.scale;
        SCP_cardEnergyFont = FontHelper.prepFont(76.0f, true);
        FontHelper.param.characters = CHAR_SET;
        FontHelper.param.gamma = 1.2f;
        FontHelper.param.borderGamma = 1.2f;
        FontHelper.param.borderWidth = 5.0f * Settings.scale;
        FontHelper.param.borderColor = new Color(0.23f, 0.26f, 0.317f, 1.0f);
        FontHelper.param.shadowOffsetX = Math.round(3.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = Math.round(3.0f * Settings.scale);
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.33f);
        bannerFont = FontHelper.prepFont(40.0f, true);
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.12f);
        FontHelper.param.shadowOffsetX = (int)(5.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(4.0f * Settings.scale);
        menuBannerFont = FontHelper.prepFont(40.0f, true);
        FontHelper.param.characters = "?";
        FontHelper.param.shadowOffsetX = (int)(15.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = (int)(12.0f * Settings.scale);
        largeCardFont = FontHelper.prepFont(120.0f, true);
        FontHelper.param.characters = CHAR_SET;
        FontHelper.param.minFilter = Texture.TextureFilter.Nearest;
        FontHelper.param.magFilter = Texture.TextureFilter.MipMapLinearNearest;
        FontHelper.param.shadowOffsetX = 2;
        FontHelper.param.shadowOffsetY = 2;
        FontHelper.param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.33f);
        FontHelper.param.gamma = 2.0f;
        FontHelper.param.borderGamma = 2.0f;
        FontHelper.param.borderStraight = true;
        FontHelper.param.borderColor = Color.DARK_GRAY.cpy();
        FontHelper.param.borderWidth = 2.0f * Settings.scale;
        FontHelper.param.shadowOffsetX = 1;
        FontHelper.param.shadowOffsetY = 1;
        tipHeaderFont = FontHelper.prepFont(23.0f, false);
        FontHelper.param.shadowOffsetX = 2;
        FontHelper.param.shadowOffsetY = 2;
        topPanelInfoFont = FontHelper.prepFont(26.0f, false);
        FontHelper.param.spaceX = 0;
        FontHelper.param.gamma = 0.9f;
        FontHelper.param.borderGamma = 0.9f;
        FontHelper.param.borderWidth = 0.0f;
        generator.dispose();
        fontFile = Gdx.files.internal("font/04b03.ttf");
        FontHelper.param.borderWidth = 2.0f * Settings.scale;
        FontHelper.param.minFilter = Texture.TextureFilter.Nearest;
        FontHelper.param.magFilter = Texture.TextureFilter.MipMapLinearNearest;
        generator = new FreeTypeFontGenerator(fontFile);
        powerAmountFont2 = FontHelper.prepFont(16.0f * Settings.scale);
        generator.dispose();
        fontFile = Gdx.files.internal("font/FeDPrm27C.otf");
        generator = new FreeTypeFontGenerator(fontFile);
        FontHelper.param.characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ?";
        FontHelper.param.gamma = 0.5f;
        FontHelper.param.borderGamma = 0.5f;
        FontHelper.param.shadowOffsetX = 0;
        FontHelper.param.shadowOffsetY = 0;
        FontHelper.param.borderWidth = 6.0f * Settings.scale;
        FontHelper.param.borderColor = new Color(0.0f, 0.0f, 0.0f, 0.5f);
        FontHelper.param.spaceX = (int)(-5.0f * Settings.scale);
        dungeonTitleFont = FontHelper.prepFont(144.0f, true);
        FontHelper.param.borderWidth = 4.0f * Settings.scale;
        FontHelper.param.borderColor = new Color(0.0f, 0.0f, 0.0f, 0.33f);
        FontHelper.param.spaceX = (int)(-2.0f * Settings.scale);
        bannerNameFont = FontHelper.prepFont(72.0f, true);
        generator.dispose();
        FontHelper.param.shadowOffsetX = 0;
        FontHelper.param.shadowOffsetY = 0;
        FontHelper.param.characters = CHAR_SET;
        FontHelper.param.borderWidth = 0.0f;
        FontHelper.param.shadowOffsetX = Math.round(2.0f * Settings.scale);
        FontHelper.param.shadowOffsetY = Math.round(2.0f * Settings.scale);
        FontHelper.param.spaceX = 0;
        fontFile = Gdx.files.internal("font/ZillaSlab-RegularItalic.otf");
        generator = new FreeTypeFontGenerator(fontFile);
        SRV_quoteFont = FontHelper.prepFont(28.0f, false);
        generator.dispose();
        logger.info("Font load time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    private static BitmapFont prepFont(float size) {
        FontHelper.param.size = (int)Math.ceil(size);
        return generator.generateFont(param);
    }

    private static BitmapFont prepFont(float size, boolean isLinearFiltering) {
        if (isLinearFiltering) {
            FontHelper.param.minFilter = Texture.TextureFilter.Linear;
            FontHelper.param.magFilter = Texture.TextureFilter.Linear;
        } else {
            FontHelper.param.minFilter = Texture.TextureFilter.Nearest;
            FontHelper.param.magFilter = Texture.TextureFilter.MipMapLinearNearest;
        }
        FontHelper.param.size = Math.round(size * Settings.scale);
        generator.scaleForPixelHeight(FontHelper.param.size);
        BitmapFont font = generator.generateFont(param);
        font.setUseIntegerPositions(!isLinearFiltering);
        return font;
    }

    public static void renderTipLeft(SpriteBatch sb, String msg) {
        layout.setText(cardDescFont_N, msg);
        sb.setColor(Color.BLACK);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, (float)InputHelper.mX - FontHelper.layout.width - 16.0f - 12.5f, (float)InputHelper.mY - FontHelper.layout.height, FontHelper.layout.width + 16.0f, FontHelper.layout.height + 16.0f);
        FontHelper.renderFont(sb, cardDescFont_N, msg, (float)InputHelper.mX - FontHelper.layout.width - 8.0f - 12.0f, (float)InputHelper.mY + 8.0f, Color.WHITE);
    }

    public static void renderFont(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        font.setColor(c);
        font.draw((Batch)sb, msg, x, y);
    }

    public static void renderRotatedText(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float offsetX, float offsetY, float angle, boolean roundY, Color c) {
        if (roundY) {
            y = (float)Math.round(y) + 0.25f;
        }
        Matrix4 mx4 = new Matrix4();
        mx4.setToRotation(new Vector3(0.0f, 0.0f, 1.0f), angle);
        Vector2 test = new Vector2(offsetX, offsetY);
        test.rotate(angle);
        mx4.trn(x + test.x, y + test.y, 0.0f);
        sb.end();
        sb.setTransformMatrix(mx4);
        sb.begin();
        font.setColor(c);
        layout.setText(font, msg);
        font.draw((Batch)sb, msg, -FontHelper.layout.width / 2.0f, FontHelper.layout.height / 2.0f);
        sb.end();
        sb.setTransformMatrix(new Matrix4());
        sb.begin();
    }

    public static void renderWrappedText(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float width) {
        FontHelper.renderWrappedText(sb, font, msg, x, y, width, Color.WHITE, 1.0f);
    }

    public static void renderWrappedText(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float width, float scale) {
        FontHelper.renderWrappedText(sb, font, msg, x, y, width, Color.WHITE, scale);
    }

    public static void renderWrappedText(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float width, Color c, float scale) {
        font.getData().setScale(scale);
        font.setColor(c);
        layout.setText(font, msg, Color.WHITE, width, 1, true);
        font.draw(sb, msg, x - width / 2.0f, y + FontHelper.layout.height / 2.0f * scale, width, 1, true);
        font.getData().setScale(1.0f);
    }

    public static void renderFontLeftDownAligned(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x, y + FontHelper.layout.height, c);
    }

    public static void renderFontRightToLeft(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        layout.setText(font, msg, c, 1.0f, 18, false);
        font.setColor(c);
        font.draw((Batch)sb, msg, x - FontHelper.layout.width, y);
    }

    public static void renderFontRightTopAligned(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x - FontHelper.layout.width, y, c);
    }

    public static void renderFontRightTopAligned(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float scale, Color c) {
        font.getData().setScale(1.0f);
        layout.setText(font, msg);
        float offsetX = FontHelper.layout.width / 2.0f;
        float offsetY = FontHelper.layout.height;
        font.getData().setScale(scale);
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x - FontHelper.layout.width / 2.0f - offsetX, y + FontHelper.layout.height / 2.0f + offsetY, c);
    }

    public static void renderSmartText(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float lineWidth, float lineSpacing, Color baseColor) {
        s = new Scanner(msg);
        Color color = null;
        float curWidth = 0.0f;
        float curHeight = 0.0f;
        layout.setText(font, " ");
        float spaceWidth = FontHelper.layout.width;
        while (s.hasNext()) {
            String word = s.next();
            if (word.equals("NL")) {
                curWidth = 0.0f;
                curHeight -= lineSpacing;
                continue;
            }
            if (word.equals("TAB")) {
                curWidth += spaceWidth * 5.0f;
                continue;
            }
            TextureAtlas.AtlasRegion orb = FontHelper.identifyOrb(word);
            if (orb == null) {
                color = FontHelper.identifyColor(word);
                if (!color.equals(Color.WHITE)) {
                    word = word.substring(2, word.length());
                    color.a = baseColor.a;
                    font.setColor(color);
                } else {
                    font.setColor(baseColor);
                }
                layout.setText(font, word);
                if (curWidth + FontHelper.layout.width > lineWidth) {
                    font.draw((Batch)sb, word, x, y + (curHeight -= lineSpacing));
                    curWidth = FontHelper.layout.width + spaceWidth;
                    continue;
                }
                font.draw((Batch)sb, word, x + curWidth, y + curHeight);
                curWidth += FontHelper.layout.width + spaceWidth;
                continue;
            }
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, baseColor.a));
            if (curWidth + CARD_ENERGY_IMG_WIDTH > lineWidth) {
                sb.draw(orb, x, y + (curHeight -= lineSpacing) - CARD_ENERGY_IMG_WIDTH + 2.0f * Settings.scale, CARD_ENERGY_IMG_WIDTH, CARD_ENERGY_IMG_WIDTH);
                curWidth = CARD_ENERGY_IMG_WIDTH + spaceWidth;
                continue;
            }
            sb.draw(orb, x + curWidth, y + curHeight - CARD_ENERGY_IMG_WIDTH + 2.0f * Settings.scale, CARD_ENERGY_IMG_WIDTH, CARD_ENERGY_IMG_WIDTH);
            curWidth += CARD_ENERGY_IMG_WIDTH + spaceWidth;
        }
        layout.setText(font, msg);
    }

    public static void renderSmartTextCentered(SpriteBatch sb, BitmapFont font, String msg, float x, float y, float lineWidth, float lineSpacing, Color baseColor) {
        s = new Scanner(msg);
        Color color = null;
        float curWidth = 0.0f;
        float curHeight = 0.0f;
        layout.setText(font, " ");
        float spaceWidth = FontHelper.layout.width;
        while (s.hasNext()) {
            String word = s.next();
            if (word.equals("NL")) {
                curWidth = 0.0f;
                curHeight -= lineSpacing;
                continue;
            }
            if (word.equals("TAB")) {
                curWidth += spaceWidth * 5.0f;
                continue;
            }
            color = FontHelper.identifyColor(word);
            if (!color.equals(Color.WHITE)) {
                word = word.substring(2, word.length());
                color.a = baseColor.a;
                font.setColor(color);
            } else {
                font.setColor(baseColor);
            }
            layout.setText(font, word);
            if (curWidth + FontHelper.layout.width > lineWidth) {
                font.draw((Batch)sb, word, x - lineWidth / 2.0f, y + (curHeight -= lineSpacing));
                curWidth = FontHelper.layout.width + spaceWidth;
                continue;
            }
            font.draw((Batch)sb, word, x + curWidth - lineWidth / 2.0f, y + curHeight);
            curWidth += FontHelper.layout.width + spaceWidth;
        }
        layout.setText(font, msg);
    }

    public static float getSmartHeight(BitmapFont font, String msg, float lineWidth, float lineSpacing) {
        s = new Scanner(msg);
        float curWidth = 0.0f;
        float curHeight = 0.0f;
        layout.setText(font, " ");
        float spaceWidth = FontHelper.layout.width;
        while (s.hasNext()) {
            String word = s.next();
            if (word.equals("NL")) {
                curWidth = 0.0f;
                curHeight -= lineSpacing;
                continue;
            }
            if (word.equals("TAB")) {
                curWidth += spaceWidth * 5.0f;
                continue;
            }
            TextureAtlas.AtlasRegion orb = FontHelper.identifyOrb(word);
            if (orb == null) {
                if (!FontHelper.identifyColor(word).equals(Color.WHITE)) {
                    word = word.substring(2, word.length());
                }
                layout.setText(font, word);
                if (curWidth + FontHelper.layout.width > lineWidth) {
                    curHeight -= lineSpacing;
                    curWidth = FontHelper.layout.width + spaceWidth;
                    continue;
                }
                curWidth += FontHelper.layout.width + spaceWidth;
                continue;
            }
            if (curWidth + CARD_ENERGY_IMG_WIDTH > lineWidth) {
                curHeight -= lineSpacing;
                curWidth = CARD_ENERGY_IMG_WIDTH + spaceWidth;
                continue;
            }
            curWidth += CARD_ENERGY_IMG_WIDTH + spaceWidth;
        }
        return curHeight;
    }

    public static float getSmartWidth(BitmapFont font, String msg, float lineWidth, float lineSpacing) {
        s = new Scanner(msg);
        float curWidth = 0.0f;
        layout.setText(font, " ");
        float spaceWidth = FontHelper.layout.width;
        while (s.hasNext()) {
            String word = s.next();
            if (word.equals("NL")) {
                curWidth = 0.0f;
                continue;
            }
            if (word.equals("TAB")) {
                curWidth += spaceWidth * 5.0f;
                continue;
            }
            TextureAtlas.AtlasRegion orb = FontHelper.identifyOrb(word);
            if (orb == null) {
                if (!FontHelper.identifyColor(word).equals(Color.WHITE)) {
                    word = word.substring(2, word.length());
                }
                layout.setText(font, word);
                if (curWidth + FontHelper.layout.width > lineWidth) {
                    curWidth = FontHelper.layout.width + spaceWidth;
                    continue;
                }
                curWidth += FontHelper.layout.width + spaceWidth;
                continue;
            }
            if (curWidth + CARD_ENERGY_IMG_WIDTH > lineWidth) {
                curWidth = CARD_ENERGY_IMG_WIDTH + spaceWidth;
                continue;
            }
            curWidth += CARD_ENERGY_IMG_WIDTH + spaceWidth;
        }
        return curWidth;
    }

    private static TextureAtlas.AtlasRegion identifyOrb(String word) {
        switch (word) {
            case "[R]": {
                return AbstractCard.orb_red;
            }
            case "[G]": {
                return AbstractCard.orb_green;
            }
            case "[B]": {
                return AbstractCard.orb_blue;
            }
        }
        return null;
    }

    private static Color identifyColor(String word) {
        if (word.charAt(0) == '#') {
            switch (word.charAt(1)) {
                case 'r': {
                    return Settings.RED_TEXT_COLOR.cpy();
                }
                case 'g': {
                    return Settings.GREEN_TEXT_COLOR.cpy();
                }
                case 'b': {
                    return Settings.BLUE_TEXT_COLOR.cpy();
                }
                case 'y': {
                    return Settings.GOLD_COLOR.cpy();
                }
                case 'p': {
                    return Settings.PURPLE_COLOR.cpy();
                }
            }
            return Color.WHITE.cpy();
        }
        return Color.WHITE.cpy();
    }

    public static void renderDeckViewTip(SpriteBatch sb, String msg, float y, Color color) {
        layout.setText(rewardTipFont, msg);
        sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.66f));
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, (float)Settings.WIDTH / 2.0f - FontHelper.layout.width / 2.0f - 12.0f * Settings.scale, y - 24.0f * Settings.scale, FontHelper.layout.width + 24.0f * Settings.scale, 48.0f * Settings.scale);
        FontHelper.renderFontCentered(sb, rewardTipFont, msg, (float)Settings.WIDTH / 2.0f, y, color);
    }

    public static void renderFontLeftTopAligned(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x, y, c);
    }

    public static void renderFontCentered(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x - FontHelper.layout.width / 2.0f, y + FontHelper.layout.height / 2.0f, c);
    }

    public static void renderFontCenteredTopAligned(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        layout.setText(font, "lL");
        font.setColor(c);
        font.draw(sb, msg, x, y + FontHelper.layout.height / 2.0f, 0.0f, 1, false);
    }

    public static void renderFontCentered(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c, float scale) {
        font.getData().setScale(scale);
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x - FontHelper.layout.width / 2.0f, y + FontHelper.layout.height / 2.0f, c);
        font.getData().setScale(1.0f);
    }

    public static void renderFontCentered(SpriteBatch sb, BitmapFont font, String msg, float x, float y) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x - FontHelper.layout.width / 2.0f, y + FontHelper.layout.height / 2.0f, Color.WHITE);
    }

    public static void renderFontCenteredWidth(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x - FontHelper.layout.width / 2.0f, y, c);
    }

    public static void renderFontCenteredWidth(SpriteBatch sb, BitmapFont font, String msg, float x, float y) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x - FontHelper.layout.width / 2.0f, y, Color.WHITE);
    }

    public static void renderFontCenteredHeight(SpriteBatch sb, BitmapFont font, String msg, float x, float y, Color c) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x, y + FontHelper.layout.height / 2.0f, c);
    }

    public static void renderFontCenteredHeight(SpriteBatch sb, BitmapFont font, String msg, float x, float y) {
        layout.setText(font, msg);
        FontHelper.renderFont(sb, font, msg, x, y + FontHelper.layout.height / 2.0f, Color.WHITE);
    }

    public static String colorString(String input, String colorValue) {
        String retVal = "";
        Scanner s = new Scanner(input);
        while (s.hasNext()) {
            retVal = retVal + "#" + colorValue + s.next();
            retVal = retVal + ' ';
        }
        s.close();
        retVal = retVal.trim();
        return retVal;
    }

    static {
        CARD_ENERGY_IMG_WIDTH = 24.0f * Settings.scale;
        layout = new GlyphLayout();
        s = null;
    }
}

