/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.Gdx;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ScrollInputProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InputHelper {
    private static final Logger logger = LogManager.getLogger(InputHelper.class.getName());
    public static int mX;
    public static int mY;
    public static boolean isMouseDown;
    public static boolean isMouseDown_R;
    private static boolean isPrevMouseDown;
    private static boolean isPrevMouseDown_R;
    public static boolean justClickedLeft;
    public static boolean justClickedRight;
    public static boolean justReleasedClickLeft;
    public static boolean justReleasedClickRight;
    public static boolean scrolledUp;
    public static boolean scrolledDown;
    public static boolean pressedEscape;
    private static ScrollInputProcessor processor;
    public static int scrollY;

    public static void initialize() {
        processor = new ScrollInputProcessor();
        Gdx.input.setInputProcessor(processor);
        logger.info("Setting input processor to Scroller");
    }

    public static void updateFirst() {
        if (Settings.WIDTH != Settings.M_W) {
            float derp = (float)Settings.M_W / (float)Settings.WIDTH;
            float derp2 = (float)Settings.M_H / (float)Settings.HEIGHT;
            mX = (int)((float)Gdx.input.getX() / derp);
            mY = (int)((float)Settings.HEIGHT - (float)Gdx.input.getY() / derp2);
        } else {
            mX = Gdx.input.getX();
            mY = Settings.HEIGHT - Gdx.input.getY();
        }
        isMouseDown = Gdx.input.isButtonPressed(0);
        isMouseDown_R = Gdx.input.isButtonPressed(1);
        if (!isPrevMouseDown && isMouseDown) {
            justClickedLeft = true;
            if (Settings.isDebug) {
                logger.info("Clicked: (" + mX + "," + mY + ")");
            }
        } else if (isPrevMouseDown && !isMouseDown) {
            justReleasedClickLeft = true;
        }
        if (!isPrevMouseDown_R && isMouseDown_R) {
            justClickedRight = true;
        } else if (isPrevMouseDown_R && !isMouseDown_R) {
            justReleasedClickRight = true;
        }
        pressedEscape = Gdx.input.isKeyJustPressed(131);
        isPrevMouseDown_R = isMouseDown_R;
        isPrevMouseDown = isMouseDown;
    }

    public static void updateLast() {
        justClickedLeft = false;
        justClickedRight = false;
        justReleasedClickLeft = false;
        scrolledUp = false;
        scrolledDown = false;
    }

    static {
        isMouseDown = false;
        isMouseDown_R = false;
        isPrevMouseDown = false;
        isPrevMouseDown_R = false;
        justClickedLeft = false;
        justClickedRight = false;
        justReleasedClickLeft = false;
        justReleasedClickRight = false;
        scrolledUp = false;
        scrolledDown = false;
        pressedEscape = false;
        scrollY = 0;
    }
}

