/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.helpers.EnemyData;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import com.megacrit.cardcrawl.monsters.thebeyond.AwakenedOne;
import com.megacrit.cardcrawl.monsters.thebeyond.Darkling;
import com.megacrit.cardcrawl.monsters.thebeyond.Deca;
import com.megacrit.cardcrawl.monsters.thebeyond.Donu;
import com.megacrit.cardcrawl.monsters.thebeyond.Exploder;
import com.megacrit.cardcrawl.monsters.thebeyond.FireOrb;
import com.megacrit.cardcrawl.monsters.thebeyond.FlameBruiser;
import com.megacrit.cardcrawl.monsters.thebeyond.GiantHead;
import com.megacrit.cardcrawl.monsters.thebeyond.Maw;
import com.megacrit.cardcrawl.monsters.thebeyond.Nemesis;
import com.megacrit.cardcrawl.monsters.thebeyond.OrbWalker;
import com.megacrit.cardcrawl.monsters.thebeyond.Puppeteer;
import com.megacrit.cardcrawl.monsters.thebeyond.Repulsor;
import com.megacrit.cardcrawl.monsters.thebeyond.Serpent;
import com.megacrit.cardcrawl.monsters.thebeyond.Spiker;
import com.megacrit.cardcrawl.monsters.thebeyond.TimeEater;
import com.megacrit.cardcrawl.monsters.thebottom.AcidSlime_L;
import com.megacrit.cardcrawl.monsters.thebottom.AcidSlime_M;
import com.megacrit.cardcrawl.monsters.thebottom.Cultist;
import com.megacrit.cardcrawl.monsters.thebottom.FungiBeast;
import com.megacrit.cardcrawl.monsters.thebottom.FuzzyLouseDefensive;
import com.megacrit.cardcrawl.monsters.thebottom.FuzzyLouseNormal;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinFat;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinNob;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinThief;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinTsundere;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinWarrior;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinWizard;
import com.megacrit.cardcrawl.monsters.thebottom.Hexaghost;
import com.megacrit.cardcrawl.monsters.thebottom.JawWorm;
import com.megacrit.cardcrawl.monsters.thebottom.Lagavulin;
import com.megacrit.cardcrawl.monsters.thebottom.Looter;
import com.megacrit.cardcrawl.monsters.thebottom.Sentry;
import com.megacrit.cardcrawl.monsters.thebottom.SlaverBlue;
import com.megacrit.cardcrawl.monsters.thebottom.SlaverRed;
import com.megacrit.cardcrawl.monsters.thebottom.SlimeBoss;
import com.megacrit.cardcrawl.monsters.thebottom.SpikeSlime_L;
import com.megacrit.cardcrawl.monsters.thebottom.SpikeSlime_M;
import com.megacrit.cardcrawl.monsters.thebottom.TheGuardian;
import com.megacrit.cardcrawl.monsters.thecity.BanditBear;
import com.megacrit.cardcrawl.monsters.thecity.BanditChild;
import com.megacrit.cardcrawl.monsters.thecity.BanditLeader;
import com.megacrit.cardcrawl.monsters.thecity.BookOfStabbing;
import com.megacrit.cardcrawl.monsters.thecity.BronzeAutomaton;
import com.megacrit.cardcrawl.monsters.thecity.Byrd;
import com.megacrit.cardcrawl.monsters.thecity.Centurion;
import com.megacrit.cardcrawl.monsters.thecity.Champ;
import com.megacrit.cardcrawl.monsters.thecity.Chosen;
import com.megacrit.cardcrawl.monsters.thecity.GremlinLeader;
import com.megacrit.cardcrawl.monsters.thecity.Healer;
import com.megacrit.cardcrawl.monsters.thecity.Mugger;
import com.megacrit.cardcrawl.monsters.thecity.ShellMonster;
import com.megacrit.cardcrawl.monsters.thecity.SnakePlant;
import com.megacrit.cardcrawl.monsters.thecity.Snecko;
import com.megacrit.cardcrawl.monsters.thecity.SphericGuardian;
import com.megacrit.cardcrawl.monsters.thecity.Taskmaster;
import com.megacrit.cardcrawl.monsters.thecity.TheCollector;
import com.megacrit.cardcrawl.monsters.thetop.CorruptHeart;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonsterHelper {
    private static final Logger logger = LogManager.getLogger(MonsterHelper.class.getName());
    private static String lastEncounterName = null;
    private static String currentEncounterName = null;
    private static String lastStrongHumanoid = null;

    public static MonsterGroup getMonster(String key) {
        lastEncounterName = currentEncounterName;
        currentEncounterName = key;
        switch (key) {
            case "FungiBeast": {
                return new MonsterGroup(new AbstractMonster[]{new FungiBeast(-400.0f, 30.0f), new FungiBeast(-40.0f, 20.0f)});
            }
            case "The Mushroom Lair": {
                return new MonsterGroup(new AbstractMonster[]{new FungiBeast(-450.0f, 30.0f), new FungiBeast(-145.0f, 20.0f), new FungiBeast(180.0f, 15.0f)});
            }
            case "JawWorm": {
                return new MonsterGroup(new JawWorm(0.0f, 25.0f));
            }
            case "Cultist": {
                return new MonsterGroup(new Cultist(0.0f, -10.0f));
            }
            case "GremlinNob": {
                return new MonsterGroup(new GremlinNob());
            }
            case "Gremlins": {
                return MonsterHelper.spawnGremlins();
            }
            case "Looter": {
                return new MonsterGroup(new Looter(0.0f, 0.0f));
            }
            case "Lagavulin": {
                return new MonsterGroup(new Lagavulin(true));
            }
            case "Lagavulin Dead Adventurers Fight": {
                return new MonsterGroup(new Lagavulin(false));
            }
            case "Sentries": {
                return new MonsterGroup(new AbstractMonster[]{new Sentry(-330.0f, 25.0f), new Sentry(-85.0f, 10.0f), new Sentry(140.0f, 30.0f)});
            }
            case "Slaver": {
                return new MonsterGroup(MonsterHelper.getSlaver(0.0f, 0.0f));
            }
            case "Blue Slaver": {
                return new MonsterGroup(new SlaverBlue(0.0f, 0.0f));
            }
            case "Red Slaver": {
                return new MonsterGroup(new SlaverRed(0.0f, 0.0f));
            }
            case "AcidSlime_L": {
                return new MonsterGroup(new AcidSlime_L(0.0f, 0.0f, 0));
            }
            case "SpikeSlime_L": {
                return new MonsterGroup(new SpikeSlime_L(0.0f, 0.0f, 0));
            }
            case "Slime": {
                if (MathUtils.randomBoolean()) {
                    return new MonsterGroup(new AcidSlime_L(0.0f, 0.0f, 0));
                }
                return new MonsterGroup(new SpikeSlime_L(0.0f, 0.0f, 0));
            }
            case "SlimeBoss": {
                return new MonsterGroup(new SlimeBoss());
            }
            case "TheGuardian": {
                return new MonsterGroup(new TheGuardian());
            }
            case "Hexaghost": {
                return new MonsterGroup(new Hexaghost());
            }
            case "Louse": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getLouse(-350.0f, 25.0f), MonsterHelper.getLouse(-125.0f, 10.0f), MonsterHelper.getLouse(80.0f, 30.0f)});
            }
            case "Exordium Wildlife": {
                return MonsterHelper.bottomWildlife();
            }
            case "Exordium Thugs": {
                return MonsterHelper.bottomHumanoid();
            }
            case "SphericGuardian": {
                return new MonsterGroup(new SphericGuardian());
            }
            case "Murder of Cultists": {
                return new MonsterGroup(new AbstractMonster[]{new Cultist(200.0f, -5.0f), new Cultist(-130.0f, 15.0f, false), new Cultist(-465.0f, -20.0f, false)});
            }
            case "BronzeAutomaton": {
                return new MonsterGroup(new BronzeAutomaton());
            }
            case "City Looters": {
                return new MonsterGroup(new AbstractMonster[]{new Looter(-200.0f, 15.0f), new Mugger(80.0f, 0.0f)});
            }
            case "4_Byrds": {
                return new MonsterGroup(new AbstractMonster[]{new Byrd(-470.0f), new Byrd(-210.0f), new Byrd(50.0f), new Byrd(310.0f)});
            }
            case "3_Byrds": {
                return new MonsterGroup(new AbstractMonster[]{new Byrd(-360.0f), new Byrd(-80.0f), new Byrd(200.0f)});
            }
            case "Champ": {
                return new MonsterGroup(new Champ());
            }
            case "Chosen": {
                return new MonsterGroup(new Chosen());
            }
            case "TheCollector": {
                return new MonsterGroup(new TheCollector());
            }
            case "The Red Mask Bandits": {
                return new MonsterGroup(new AbstractMonster[]{new BanditLeader(), new BanditBear(-200.0f, 0.0f), new BanditChild(200.0f, 0.0f)});
            }
            case "HealerTank": {
                return new MonsterGroup(new AbstractMonster[]{new Centurion(-200.0f, 15.0f), new Healer(120.0f, 0.0f)});
            }
            case "Shelled Parasite": {
                return new MonsterGroup(new ShellMonster());
            }
            case "Snecko": {
                return new MonsterGroup(new Snecko());
            }
            case "BookOfStabbing": {
                return new MonsterGroup(new BookOfStabbing());
            }
            case "SlaverBoss": {
                return new MonsterGroup(new AbstractMonster[]{new SlaverBlue(-385.0f, -15.0f), new Taskmaster(-133.0f, 0.0f), new SlaverRed(125.0f, -30.0f)});
            }
            case "Gremlin Leader Combat": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.spawnGremlin(-366.0f, -4.0f), MonsterHelper.spawnGremlin(-170.0f, 6.0f), new GremlinLeader()});
            }
            case "Chosen and Flock": {
                return new MonsterGroup(new AbstractMonster[]{new Chosen(80.0f, 0.0f), new Byrd(-170.0f)});
            }
            case "City Thugs": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getSlaver(-355.0f, -30.0f), new ShellMonster(50.0f, 10.0f)});
            }
            case "City Ancients": {
                return new MonsterGroup(new AbstractMonster[]{new Sentry(-305.0f, 30.0f), new SphericGuardian()});
            }
            case "SnakePlant": {
                return new MonsterGroup(new SnakePlant(-30.0f, -30.0f));
            }
            case "Flame Bruiser (One Orb)": {
                return new MonsterGroup(new AbstractMonster[]{new FlameBruiser(), new FireOrb(180.0f, 50.0f)});
            }
            case "Flame Bruiser (Two Orb)": {
                return new MonsterGroup(new AbstractMonster[]{new FlameBruiser(), new FireOrb(180.0f, 50.0f), new FireOrb(-180.0f, 80.0f)});
            }
            case "Darkling Encounter": {
                return new MonsterGroup(new AbstractMonster[]{new Darkling(-440.0f, 10.0f), new Darkling(-140.0f, 30.0f), new Darkling(180.0f, -5.0f)});
            }
            case "GiantHead": {
                return new MonsterGroup(new GiantHead());
            }
            case "MultipleMaws": {
                return new MonsterGroup(new AbstractMonster[]{new Maw(-350.0f, 15.0f), new Maw(120.0f, -20.0f)});
            }
            case "Maw": {
                return new MonsterGroup(new Maw(-70.0f, 20.0f));
            }
            case "Serpent": {
                return new MonsterGroup(new Serpent());
            }
            case "SPHERE_COMBAT": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getAncientShape(-475.0f, 10.0f), new OrbWalker(150.0f, 30.0f), MonsterHelper.getAncientShape(-250.0f, 0.0f)});
            }
            case "Orb Walker": {
                return new MonsterGroup(new OrbWalker(-30.0f, 30.0f));
            }
            case "Double Orb Walker": {
                return new MonsterGroup(new AbstractMonster[]{new OrbWalker(150.0f, 36.0f), new OrbWalker(-250.0f, 42.0f)});
            }
            case "Puppeteer": {
                return new MonsterGroup(new Puppeteer());
            }
            case "Ancient Shapes": {
                return MonsterHelper.spawnShapes(false);
            }
            case "Ancient Shapes Weak": {
                return MonsterHelper.spawnShapes(true);
            }
            case "Nemesis": {
                return new MonsterGroup(new Nemesis());
            }
            case "AwakenedOne": {
                return new MonsterGroup(new AbstractMonster[]{new AwakenedOne(100.0f, 15.0f), new Cultist(-298.0f, -10.0f, false), new Cultist(-590.0f, 10.0f, false)});
            }
            case "TimeEater": {
                return new MonsterGroup(new TimeEater());
            }
            case "Donu and Deca": {
                return new MonsterGroup(new AbstractMonster[]{new Deca(), new Donu()});
            }
            case "CorruptHeart": {
                return new MonsterGroup(new CorruptHeart());
            }
        }
        logger.info("Unspecified key: " + key + " in MonsterHelper.");
        return null;
    }

    private static float randomYOffset(float y) {
        return y + MathUtils.random(-20.0f, 20.0f);
    }

    private static float randomXOffset(float x) {
        return x + MathUtils.random(-20.0f, 20.0f);
    }

    public static AbstractMonster getGremlin(String key, float xPos, float yPos) {
        switch (key) {
            case "GremlinWarrior": {
                return new GremlinWarrior(xPos, yPos, false);
            }
            case "GremlinThief": {
                return new GremlinThief(xPos, yPos, false);
            }
            case "GremlinFat": {
                return new GremlinFat(xPos, yPos, false);
            }
            case "GremlinTsundere": {
                return new GremlinTsundere(xPos, yPos, false);
            }
            case "GremlinWizard": {
                return new GremlinWizard(xPos, yPos, false);
            }
        }
        logger.info("UNKNOWN GREMLIN: " + key);
        return null;
    }

    public static AbstractMonster getAncientShape(float x, float y) {
        switch (MathUtils.random(2)) {
            case 0: {
                return new Spiker(x, y);
            }
            case 1: {
                return new Repulsor(x, y);
            }
        }
        return new Exploder(x, y);
    }

    public static AbstractMonster getShape(String key, float xPos, float yPos) {
        switch (key) {
            case "Repulsor": {
                return new Repulsor(xPos, yPos);
            }
            case "Spiker": {
                return new Spiker(xPos, yPos);
            }
            case "Exploder": {
                return new Exploder(xPos, yPos);
            }
        }
        logger.info("UNKNOWN SHAPE: " + key);
        return null;
    }

    private static MonsterGroup spawnShapes(boolean weak) {
        ArrayList<String> shapePool = new ArrayList<String>();
        shapePool.add("Repulsor");
        shapePool.add("Repulsor");
        shapePool.add("Exploder");
        shapePool.add("Exploder");
        shapePool.add("Spiker");
        shapePool.add("Spiker");
        AbstractMonster[] retVal = weak ? new AbstractMonster[3] : new AbstractMonster[4];
        int index = MathUtils.random(shapePool.size() - 1);
        String key = (String)shapePool.get(index);
        shapePool.remove(index);
        retVal[0] = MonsterHelper.getShape(key, -480.0f, 6.0f);
        index = MathUtils.random(shapePool.size() - 1);
        key = (String)shapePool.get(index);
        shapePool.remove(index);
        retVal[1] = MonsterHelper.getShape(key, -240.0f, -6.0f);
        index = MathUtils.random(shapePool.size() - 1);
        key = (String)shapePool.get(index);
        shapePool.remove(index);
        retVal[2] = MonsterHelper.getShape(key, 0.0f, -12.0f);
        if (!weak) {
            index = MathUtils.random(shapePool.size() - 1);
            key = (String)shapePool.get(index);
            shapePool.remove(index);
            retVal[3] = MonsterHelper.getShape(key, 240.0f, 12.0f);
        }
        return new MonsterGroup(retVal);
    }

    private static MonsterGroup spawnGremlins() {
        ArrayList<String> gremlinPool = new ArrayList<String>();
        gremlinPool.add("GremlinWarrior");
        gremlinPool.add("GremlinWarrior");
        gremlinPool.add("GremlinThief");
        gremlinPool.add("GremlinThief");
        gremlinPool.add("GremlinFat");
        gremlinPool.add("GremlinFat");
        gremlinPool.add("GremlinTsundere");
        gremlinPool.add("GremlinWizard");
        AbstractMonster[] retVal = new AbstractMonster[4];
        int index = MathUtils.random(gremlinPool.size() - 1);
        String key = (String)gremlinPool.get(index);
        gremlinPool.remove(index);
        retVal[0] = MonsterHelper.getGremlin(key, -320.0f, 25.0f);
        index = MathUtils.random(gremlinPool.size() - 1);
        key = (String)gremlinPool.get(index);
        gremlinPool.remove(index);
        retVal[1] = MonsterHelper.getGremlin(key, -160.0f, -12.0f);
        index = MathUtils.random(gremlinPool.size() - 1);
        key = (String)gremlinPool.get(index);
        gremlinPool.remove(index);
        retVal[2] = MonsterHelper.getGremlin(key, 25.0f, -35.0f);
        index = MathUtils.random(gremlinPool.size() - 1);
        key = (String)gremlinPool.get(index);
        gremlinPool.remove(index);
        retVal[3] = MonsterHelper.getGremlin(key, 205.0f, 40.0f);
        return new MonsterGroup(retVal);
    }

    private static AbstractMonster spawnGremlin(float x, float y) {
        ArrayList<String> gremlinPool = new ArrayList<String>();
        gremlinPool.add("GremlinWarrior");
        gremlinPool.add("GremlinWarrior");
        gremlinPool.add("GremlinThief");
        gremlinPool.add("GremlinThief");
        gremlinPool.add("GremlinFat");
        gremlinPool.add("GremlinFat");
        gremlinPool.add("GremlinTsundere");
        gremlinPool.add("GremlinWizard");
        return MonsterHelper.getGremlin((String)gremlinPool.get(MathUtils.random(0, gremlinPool.size() - 1)), x, y);
    }

    private static MonsterGroup bottomHumanoid() {
        AbstractMonster[] monsters = new AbstractMonster[]{MonsterHelper.bottomGetStrongHumanoid(MonsterHelper.randomXOffset(-130.0f), MonsterHelper.randomYOffset(20.0f)), MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(130.0f), MonsterHelper.randomYOffset(20.0f))};
        return new MonsterGroup(monsters);
    }

    private static MonsterGroup bottomWildlife() {
        int numMonster = 2;
        AbstractMonster[] monsters = new AbstractMonster[numMonster];
        if (numMonster == 2) {
            monsters[0] = MonsterHelper.bottomGetStrongWildlife(MonsterHelper.randomXOffset(-150.0f), MonsterHelper.randomYOffset(20.0f));
            monsters[1] = MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(150.0f), MonsterHelper.randomYOffset(20.0f));
        } else if (numMonster == 3) {
            monsters[0] = MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(-200.0f), MonsterHelper.randomYOffset(20.0f));
            monsters[1] = MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(0.0f), MonsterHelper.randomYOffset(20.0f));
            monsters[2] = MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(200.0f), MonsterHelper.randomYOffset(20.0f));
        }
        return new MonsterGroup(monsters);
    }

    private static AbstractMonster bottomGetStrongHumanoid(float x, float y) {
        ArrayList<AbstractMonster> monsters = new ArrayList<AbstractMonster>();
        monsters.add(new Cultist(x, y));
        monsters.add(MonsterHelper.getSlaver(x, y));
        monsters.add(new Looter(x, y));
        monsters.removeIf(m -> m.id.equals(lastStrongHumanoid) || m.id.equals(lastEncounterName));
        AbstractMonster output = (AbstractMonster)monsters.get(MathUtils.random(0, monsters.size() - 1));
        lastStrongHumanoid = output.id;
        return output;
    }

    private static AbstractMonster bottomGetStrongWildlife(float x, float y) {
        ArrayList<AbstractMonster> monsters = new ArrayList<AbstractMonster>();
        monsters.add(new FungiBeast(x, y));
        monsters.add(new JawWorm(x, y));
        AbstractMonster output = (AbstractMonster)monsters.get(MathUtils.random(0, monsters.size() - 1));
        return output;
    }

    private static AbstractMonster bottomGetWeakWildlife(float x, float y) {
        ArrayList<AbstractMonster> monsters = new ArrayList<AbstractMonster>();
        monsters.add(MonsterHelper.getLouse(x, y));
        monsters.add(new SpikeSlime_M(x, y, 0, MathUtils.random(28, 32)));
        monsters.add(new AcidSlime_M(x, y, 0, MathUtils.random(28, 32)));
        return (AbstractMonster)monsters.get(MathUtils.random(0, monsters.size() - 1));
    }

    private static AbstractMonster getSlaver(float x, float y) {
        if (MathUtils.randomBoolean()) {
            return new SlaverRed(x, y);
        }
        return new SlaverBlue(x, y);
    }

    private static AbstractMonster getLouse(float x, float y) {
        if (MathUtils.randomBoolean()) {
            return new FuzzyLouseNormal(x, y);
        }
        return new FuzzyLouseDefensive(x, y);
    }

    public static void uploadEnemyData() {
        ArrayList<String> derp = new ArrayList<String>();
        ArrayList<EnemyData> data = new ArrayList<EnemyData>();
        data.add(new EnemyData("Looter", 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("JawWorm", 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Cultist", 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Blue Slaver", 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Louse", 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Gremlins", 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Exordium Wildlife", 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Exordium Thugs", 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("FungiBeast", 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Red Slaver", 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Slime", 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("GremlinNob", 1, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("Lagavulin", 1, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("Sentries", 1, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("Lagavulin Dead Adventurers Fight", 1, EnemyData.MonsterType.EVENT));
        data.add(new EnemyData("The Mushroom Lair", 1, EnemyData.MonsterType.EVENT));
        data.add(new EnemyData("TheGuardian", 1, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData("Hexaghost", 1, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData("SlimeBoss", 1, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData("Murder of Cultists", 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("SphericGuardian", 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Chosen", 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("3_Byrds", 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Shelled Parasite", 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("City Looters", 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Snecko", 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("SnakePlant", 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("HealerTank", 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Chosen and Flock", 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("City Thugs", 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("City Ancients", 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("SlaverBoss", 2, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("BookOfStabbing", 2, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("Gremlin Leader Combat", 2, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("Masked Bandits", 2, EnemyData.MonsterType.EVENT));
        data.add(new EnemyData("BronzeAutomaton", 2, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData("Champ", 2, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData("TheCollector", 2, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData("Flame Bruiser (One Orb)", 3, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Darkling Encounter", 3, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Orb Walker", 3, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Ancient Shapes Weak", 3, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData("Flame Bruiser (Two Orb)", 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Maw", 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Serpent", 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Puppeteer", 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("Ancient Shapes", 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData("GiantHead", 3, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("Nemesis", 3, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("Double Orb Walker", 3, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData("SPHERE_COMBAT", 3, EnemyData.MonsterType.EVENT));
        data.add(new EnemyData("AwakenedOne", 3, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData("Donu and Deca", 3, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData("TimeEater", 3, EnemyData.MonsterType.BOSS));
        for (EnemyData d : data) {
            derp.add(d.debugDetailedEnemyDataString());
        }
        LeaderboardPoster poster = new LeaderboardPoster();
        poster.setValues(LeaderboardPoster.LeaderboardDataType.ENEMY_DATA, "", EnemyData.debugDetailedEnemyDataHeader(), derp, false);
        Thread t = new Thread(poster);
        t.run();
    }
}

