/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thebottom;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateSlowAttackAction;
import com.megacrit.cardcrawl.actions.animations.VFXAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.ChangeStateAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.common.MakeTempCardInDiscardAction;
import com.megacrit.cardcrawl.actions.unique.BurnIncreaseAction;
import com.megacrit.cardcrawl.actions.utility.SFXAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.cards.status.Burn;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.thebottom.HexaghostBody;
import com.megacrit.cardcrawl.monsters.thebottom.HexaghostOrb;
import com.megacrit.cardcrawl.powers.StrengthPower;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.BorderFlashEffect;
import com.megacrit.cardcrawl.vfx.combat.FireballEffect;
import com.megacrit.cardcrawl.vfx.combat.GhostIgniteEffect;
import com.megacrit.cardcrawl.vfx.combat.InflameEffect;
import com.megacrit.cardcrawl.vfx.combat.ScreenOnFireEffect;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Hexaghost
extends AbstractMonster {
    private static final Logger logger = LogManager.getLogger(Hexaghost.class.getName());
    public static final String ID = "Hexaghost";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("Hexaghost");
    public static final String NAME = Hexaghost.monsterStrings.NAME;
    public static final String[] MOVES = Hexaghost.monsterStrings.MOVES;
    public static final String[] DIALOG = Hexaghost.monsterStrings.DIALOG;
    public static final String IMAGE = "images/monsters/theBottom/boss/ghost/core.png";
    private static final int HP = 250;
    private ArrayList<HexaghostOrb> orbs = new ArrayList();
    private int searDamage = 6;
    private int strengthenBlockAmt = 12;
    private int strAmount = 2;
    private int searBurnCount = 1;
    private int fireTackleDamage = 5;
    private int fireTackleCount = 2;
    private int infernoDamage = 3;
    private int infernoHits = 6;
    private static final byte DIVIDER = 1;
    private static final byte TACKLE = 2;
    private static final byte INFLAME = 3;
    private static final byte SEAR = 4;
    private static final byte ACTIVATE = 5;
    private static final byte INFERNO = 6;
    private static final String STRENGTHEN_NAME = MOVES[0];
    private static final String SEAR_NAME = MOVES[1];
    private static final String BURN_NAME = MOVES[2];
    private static final String ACTIVATE_STATE = "Activate";
    private static final String ACTIVATE_ORB = "Activate Orb";
    private static final String DEACTIVATE_ALL_ORBS = "Deactivate";
    private boolean activated = false;
    private boolean burnUpgraded = false;
    private int orbActiveCount = 0;
    private int strengthTurnCount = 0;
    private HexaghostBody body;

    public Hexaghost() {
        super(NAME, ID, 250, 20.0f, 0.0f, 450.0f, 450.0f, IMAGE);
        this.type = AbstractMonster.EnemyType.BOSS;
        this.body = new HexaghostBody(this);
        this.createOrbs();
        this.damage.add(new DamageInfo(this, this.fireTackleDamage));
        this.damage.add(new DamageInfo(this, this.searDamage));
        this.damage.add(new DamageInfo(this, -1));
        this.damage.add(new DamageInfo(this, this.infernoDamage));
    }

    @Override
    public void usePreBattleAction() {
        UnlockTracker.markBossAsSeen("GHOST");
    }

    private void createOrbs() {
        this.orbs.add(new HexaghostOrb(-90.0f, 380.0f, this.orbs.size()));
        this.orbs.add(new HexaghostOrb(90.0f, 380.0f, this.orbs.size()));
        this.orbs.add(new HexaghostOrb(160.0f, 250.0f, this.orbs.size()));
        this.orbs.add(new HexaghostOrb(90.0f, 120.0f, this.orbs.size()));
        this.orbs.add(new HexaghostOrb(-90.0f, 120.0f, this.orbs.size()));
        this.orbs.add(new HexaghostOrb(-160.0f, 250.0f, this.orbs.size()));
    }

    @Override
    public void takeTurn() {
        ++this.strengthTurnCount;
        switch (this.nextMove) {
            case 5: {
                int d;
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, ACTIVATE_STATE));
                ((DamageInfo)this.damage.get((int)2)).base = d = AbstractDungeon.player.currentHealth / 12 + 1;
                this.applyPowers();
                this.setMove((byte)1, AbstractMonster.Intent.ATTACK, ((DamageInfo)this.damage.get((int)2)).base, 6, true);
                break;
            }
            case 1: {
                for (int i = 0; i < 6; ++i) {
                    AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new GhostIgniteEffect(AbstractDungeon.player.hb.cX + MathUtils.random(-120.0f, 120.0f) * Settings.scale, AbstractDungeon.player.hb.cY + MathUtils.random(-120.0f, 120.0f) * Settings.scale), 0.05f));
                    if (MathUtils.randomBoolean()) {
                        AbstractDungeon.actionManager.addToBottom(new SFXAction("GHOST_ORB_IGNITE_1", 0.3f));
                    } else {
                        AbstractDungeon.actionManager.addToBottom(new SFXAction("GHOST_ORB_IGNITE_2", 0.3f));
                    }
                    AbstractDungeon.actionManager.addToBottom(new DamageAction(AbstractDungeon.player, (DamageInfo)this.damage.get(2), AbstractGameAction.AttackEffect.BLUNT_HEAVY, true));
                }
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, DEACTIVATE_ALL_ORBS));
                this.rollMove();
                break;
            }
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new VFXAction(new BorderFlashEffect(Color.CHARTREUSE)));
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.FIRE));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.FIRE));
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, ACTIVATE_ORB));
                this.rollMove();
                break;
            }
            case 4: {
                AbstractDungeon.actionManager.addToBottom(new VFXAction(new FireballEffect(this.hb.cX, this.hb.cY, AbstractDungeon.player.hb.cX, AbstractDungeon.player.hb.cY), 0.5f));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(1), AbstractGameAction.AttackEffect.FIRE));
                Burn c = new Burn();
                if (this.burnUpgraded) {
                    c.upgrade();
                }
                AbstractDungeon.actionManager.addToBottom(new MakeTempCardInDiscardAction(c, this.searBurnCount));
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, ACTIVATE_ORB));
                this.rollMove();
                break;
            }
            case 3: {
                AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new InflameEffect(this), 0.5f));
                AbstractDungeon.actionManager.addToBottom(new GainBlockAction(this, this, this.strengthenBlockAmt));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new StrengthPower(this, this.strAmount), this.strAmount));
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, ACTIVATE_ORB));
                this.rollMove();
                break;
            }
            case 6: {
                AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new ScreenOnFireEffect(), 1.0f));
                for (int i = 0; i < this.infernoHits; ++i) {
                    AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(3), AbstractGameAction.AttackEffect.FIRE));
                }
                AbstractDungeon.actionManager.addToBottom(new BurnIncreaseAction());
                if (!this.burnUpgraded) {
                    this.burnUpgraded = true;
                }
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, DEACTIVATE_ALL_ORBS));
                this.rollMove();
                break;
            }
            default: {
                logger.info("ERROR: Default Take Turn was called on " + this.name);
            }
        }
    }

    @Override
    protected void getMove(int num) {
        if (!this.activated) {
            this.activated = true;
            this.setMove((byte)5, AbstractMonster.Intent.UNKNOWN);
        } else {
            if (this.strengthTurnCount >= 4) {
                if (this.lastMove((byte)3)) {
                    if (MathUtils.randomBoolean()) {
                        this.setMove(SEAR_NAME, (byte)4, AbstractMonster.Intent.ATTACK_DEBUFF, this.searDamage);
                        return;
                    }
                    this.setMove((byte)2, AbstractMonster.Intent.ATTACK, this.fireTackleDamage, this.fireTackleCount, true);
                    return;
                }
                this.setMove(STRENGTHEN_NAME, (byte)3, AbstractMonster.Intent.DEFEND_BUFF);
                this.strengthTurnCount = 0;
                return;
            }
            if (num >= 50) {
                if (this.lastTwoMoves((byte)4)) {
                    if (MathUtils.randomBoolean()) {
                        this.setMove(STRENGTHEN_NAME, (byte)3, AbstractMonster.Intent.DEFEND_BUFF);
                    } else {
                        this.setMove((byte)2, AbstractMonster.Intent.ATTACK, this.fireTackleDamage, this.fireTackleCount, true);
                    }
                } else {
                    this.setMove(SEAR_NAME, (byte)4, AbstractMonster.Intent.ATTACK_DEBUFF, this.searDamage);
                }
            } else if (this.lastTwoMoves((byte)2)) {
                if (MathUtils.randomBoolean()) {
                    this.setMove(SEAR_NAME, (byte)4, AbstractMonster.Intent.ATTACK_DEBUFF, this.searDamage);
                } else {
                    this.setMove(STRENGTHEN_NAME, (byte)3, AbstractMonster.Intent.DEFEND_BUFF);
                }
            } else {
                this.setMove((byte)2, AbstractMonster.Intent.ATTACK, this.fireTackleDamage, this.fireTackleCount, true);
            }
        }
    }

    @Override
    public void changeState(String stateName) {
        switch (stateName) {
            case "Activate": {
                AbstractDungeon.scene.fadeOutAmbiance();
                AbstractDungeon.getCurrRoom().playBgmInstantly("BOSS_BOTTOM");
                for (HexaghostOrb orb : this.orbs) {
                    orb.activate(this.drawX + this.animX, this.drawY + this.animY);
                }
                this.orbActiveCount = 6;
                this.body.targetRotationSpeed = 120.0f;
                break;
            }
            case "Activate Orb": {
                for (HexaghostOrb orb : this.orbs) {
                    if (orb.activated) continue;
                    orb.activate(this.drawX + this.animX, this.drawY + this.animY);
                    break;
                }
                ++this.orbActiveCount;
                if (this.orbActiveCount != 6) break;
                this.setMove(BURN_NAME, (byte)6, AbstractMonster.Intent.ATTACK_DEBUFF, this.infernoDamage, this.infernoHits, true);
                break;
            }
            case "Deactivate": {
                for (HexaghostOrb orb : this.orbs) {
                    orb.deactivate();
                }
                CardCrawlGame.sound.play("CARD_EXHAUST", 0.2f);
                CardCrawlGame.sound.play("CARD_EXHAUST", 0.2f);
                this.orbActiveCount = 0;
            }
        }
    }

    @Override
    public void die() {
        this.useFastShakeAnimation(5.0f);
        CardCrawlGame.screenShake.rumble(4.0f);
        this.deathTimer += 1.5f;
        super.die();
        for (HexaghostOrb orb : this.orbs) {
            orb.hide();
        }
        this.onBossVictoryLogic();
        UnlockTracker.hardUnlockOverride("GHOST");
        UnlockTracker.unlockAchievement("GHOST_GUARDIAN");
    }

    @Override
    public void update() {
        super.update();
        this.body.update();
        for (HexaghostOrb orb : this.orbs) {
            orb.update(this.drawX + this.animX, this.drawY + this.animY);
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        this.body.render(sb);
        super.render(sb);
    }
}

