/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.AnimationState;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateFastAttackAction;
import com.megacrit.cardcrawl.actions.common.ChangeStateAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.actions.unique.GainBlockRandomMonsterAction;
import com.megacrit.cardcrawl.actions.utility.SFXAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Centurion
extends AbstractMonster {
    public static final String ID = "Centurion";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("Centurion");
    public static final String NAME = Centurion.monsterStrings.NAME;
    public static final String[] MOVES = Centurion.monsterStrings.MOVES;
    public static final String[] DIALOG = Centurion.monsterStrings.DIALOG;
    private int SLASH_DMG = 12;
    private int FURY_DMG = 6;
    private int FURY_HITS = 3;
    private int BLOCK_AMOUNT = 15;
    private static final byte SLASH = 1;
    private static final byte PROTECT = 2;
    private static final byte FURY = 3;

    public Centurion(float x, float y) {
        super(NAME, ID, 78, -14.0f, -20.0f, 250.0f, 330.0f, null, x, y);
        this.damage.add(new DamageInfo(this, this.SLASH_DMG));
        this.damage.add(new DamageInfo(this, this.FURY_DMG));
        this.loadAnimation("images/monsters/theCity/tank/skeleton.atlas", "images/monsters/theCity/tank/skeleton.json", 1.0f);
        AnimationState.TrackEntry e = this.state.setAnimation(0, "idle", true);
        e.setTime(e.getEndTime() * MathUtils.random());
        this.state.setTimeScale(2.0f);
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 1: {
                this.playSfx();
                AbstractDungeon.actionManager.addToBottom(new AnimateFastAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.BLUNT_LIGHT));
                break;
            }
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, "BLOCK_ANIM"));
                AbstractDungeon.actionManager.addToBottom(new WaitAction(0.25f));
                AbstractDungeon.actionManager.addToBottom(new GainBlockRandomMonsterAction(this, this.BLOCK_AMOUNT));
                break;
            }
            case 3: {
                for (int i = 0; i < this.FURY_HITS; ++i) {
                    this.playSfx();
                    AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, "MACE_HIT"));
                    AbstractDungeon.actionManager.addToBottom(new WaitAction(0.4f));
                    AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(1), AbstractGameAction.AttackEffect.BLUNT_HEAVY));
                }
                break;
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    private void playSfx() {
        int roll = MathUtils.random(1);
        if (roll == 0) {
            AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_TANK_1A"));
        } else if (roll == 1) {
            AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_TANK_1B"));
        } else {
            AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_TANK_1C"));
        }
    }

    @Override
    public void changeState(String key) {
        switch (key) {
            case "BLOCK_ANIM": {
                this.state.setAnimation(0, "block", false);
                this.state.addAnimation(0, "idle", true, 0.0f);
                break;
            }
            case "MACE_HIT": {
                this.state.setAnimation(0, "mace_hit", false);
                this.state.addAnimation(0, "idle", true, 0.0f);
                this.state.setTimeScale(2.5f);
                break;
            }
        }
    }

    @Override
    protected void getMove(int num) {
        if (num >= 65 && !this.lastTwoMoves((byte)2) && !this.lastTwoMoves((byte)3)) {
            int aliveCount = 0;
            for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
                if (m.isDying || m.isEscaping) continue;
                ++aliveCount;
            }
            if (aliveCount > 1) {
                this.setMove((byte)2, AbstractMonster.Intent.DEFEND);
                return;
            }
            this.setMove((byte)3, AbstractMonster.Intent.ATTACK, this.FURY_DMG, this.FURY_HITS, true);
            return;
        }
        if (!this.lastTwoMoves((byte)1)) {
            this.setMove((byte)1, AbstractMonster.Intent.ATTACK, this.SLASH_DMG);
            return;
        }
        int aliveCount = 0;
        for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
            if (m.isDying || m.isEscaping) continue;
            ++aliveCount;
        }
        if (aliveCount > 1) {
            this.setMove((byte)2, AbstractMonster.Intent.DEFEND);
            return;
        }
        this.setMove((byte)3, AbstractMonster.Intent.ATTACK, this.FURY_DMG, this.FURY_HITS, true);
    }

    @Override
    public void damage(DamageInfo info) {
        super.damage(info);
        if (info.output > 0) {
            AnimationState.TrackEntry e = this.state.setAnimation(0, "damaged", false);
            this.state.setTimeScale(1.5f);
            e.setTime(e.getEndTime() * 0.3f);
            this.state.addAnimation(0, "idle", true, 0.0f);
        }
    }

    @Override
    public void die() {
        this.state.setTimeScale(0.1f);
        this.useShakeAnimation(5.0f);
        super.die();
    }
}

