/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.potions;

import com.megacrit.cardcrawl.actions.common.ExhaustSpecificCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.vfx.ThoughtBubble;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElixirPotion
extends AbstractPotion {
    private static final Logger logger = LogManager.getLogger(ElixirPotion.class.getName());
    public static final String POTION_ID = "Elixir";
    private static final PotionStrings potionStrings = CardCrawlGame.languagePack.getPotionString("Elixir");
    public static final String NAME = ElixirPotion.potionStrings.NAME;
    public static final String[] DESCRIPTIONS = ElixirPotion.potionStrings.DESCRIPTIONS;

    public ElixirPotion() {
        super(NAME, POTION_ID, AbstractPotion.PotionSize.T, AbstractPotion.PotionColor.ELIXIR);
        this.potency = 2;
        this.description = DESCRIPTIONS[2];
        this.isThrown = false;
        this.tips.add(new PowerTip(this.name, this.description));
        this.tips.add(new PowerTip("Exhaust", GameDictionary.keywords.get("exhaust")));
        this.tips.add(new PowerTip("Status", GameDictionary.keywords.get("status")));
    }

    @Override
    public void use(AbstractCreature target) {
        if (target.isPlayer) {
            ArrayList<AbstractCard> handCopy = new ArrayList<AbstractCard>();
            for (AbstractCard c : AbstractDungeon.player.hand.group) {
                if (c.type != AbstractCard.CardType.STATUS) continue;
                handCopy.add(c);
            }
            if (handCopy.isEmpty()) {
                AbstractDungeon.effectList.add(new ThoughtBubble(AbstractDungeon.player.dialogX, AbstractDungeon.player.dialogY, 3.0f, DESCRIPTIONS[4], true));
            }
            if (!handCopy.isEmpty()) {
                for (AbstractCard c : handCopy) {
                    AbstractDungeon.actionManager.addToTop(new ExhaustSpecificCardAction(c, AbstractDungeon.player.hand));
                }
                handCopy.clear();
                logger.info("REMOVING ALL STATUSES FROM HAND...");
            }
        } else {
            AbstractDungeon.effectList.add(new ThoughtBubble(AbstractDungeon.player.dialogX, AbstractDungeon.player.dialogY, 3.0f, DESCRIPTIONS[4], true));
        }
    }

    @Override
    public AbstractPotion makeCopy() {
        return new ElixirPotion();
    }
}

