/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.potions;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.powers.PoisonPower;

public class PoisonPotion
extends AbstractPotion {
    public static final String POTION_ID = "Poison Potion";
    private static final PotionStrings potionStrings = CardCrawlGame.languagePack.getPotionString("Poison Potion");
    public static final String NAME = PoisonPotion.potionStrings.NAME;
    public static final String[] DESCRIPTIONS = PoisonPotion.potionStrings.DESCRIPTIONS;

    public PoisonPotion() {
        super(NAME, POTION_ID, AbstractPotion.PotionSize.L, AbstractPotion.PotionColor.POISON);
        this.potency = 6;
        this.description = DESCRIPTIONS[0] + this.potency + DESCRIPTIONS[1];
        this.isThrown = true;
        this.targetRequired = true;
        this.tips.add(new PowerTip(this.name, this.description));
        this.tips.add(new PowerTip("Poison", GameDictionary.keywords.get("poison")));
    }

    @Override
    public void use(AbstractCreature target) {
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(target, AbstractDungeon.player, new PoisonPower(target, AbstractDungeon.player, this.potency), this.potency));
    }

    @Override
    public AbstractPotion makeCopy() {
        return new PoisonPotion();
    }
}

