/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.potions;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.powers.WeakPower;

public class WeakenPotion
extends AbstractPotion {
    public static final String POTION_ID = "Weak Potion";
    private static final PotionStrings potionStrings = CardCrawlGame.languagePack.getPotionString("Weak Potion");
    public static final String NAME = WeakenPotion.potionStrings.NAME;
    public static final String[] DESCRIPTIONS = WeakenPotion.potionStrings.DESCRIPTIONS;

    public WeakenPotion() {
        super(NAME, POTION_ID, AbstractPotion.PotionSize.H, AbstractPotion.PotionColor.WEAK);
        this.potency = 3;
        this.description = DESCRIPTIONS[0] + this.potency + DESCRIPTIONS[1];
        this.isThrown = true;
        this.targetRequired = true;
        this.tips.add(new PowerTip(this.name, this.description));
        this.tips.add(new PowerTip("Weak", GameDictionary.keywords.get("weak")));
    }

    @Override
    public void use(AbstractCreature target) {
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(target, AbstractDungeon.player, new WeakPower(target, this.potency, false), this.potency));
    }

    @Override
    public AbstractPotion makeCopy() {
        return new WeakenPotion();
    }
}

