/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.common.GainChargeAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class AbsorbPower
extends AbstractPower {
    public static final String POWER_ID = "Absorb";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Absorb");
    public static final String NAME = AbsorbPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = AbsorbPower.powerStrings.DESCRIPTIONS;

    public AbsorbPower(AbstractCreature owner, int chargeAmt) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = chargeAmt;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/absorb.png");
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1];
    }

    @Override
    public void atEndOfRound() {
        AbstractDungeon.actionManager.addToBottom(new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
    }

    @Override
    public int onAttacked(DamageInfo info, int damageAmount) {
        this.flash();
        if (info.type == DamageInfo.DamageType.NORMAL) {
            AbstractDungeon.actionManager.addToTop(new GainChargeAction(this.amount));
        }
        return damageAmount;
    }
}

