/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.actions.common.ReducePowerAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class GambitPower
extends AbstractPower {
    public static final String POWER_ID = "Gambit";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Gambit");
    public static final String NAME = GambitPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = GambitPower.powerStrings.DESCRIPTIONS;
    private int energyAmt;

    public GambitPower(AbstractCreature owner, int energyAmt) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.energyAmt = energyAmt;
        this.amount = 3;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/xanatos.png");
        this.isTurnBased = true;
    }

    @Override
    public void updateDescription() {
        this.description = this.amount == 1 ? DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1] + this.energyAmt + DESCRIPTIONS[3] : DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[2] + this.energyAmt + DESCRIPTIONS[3];
    }

    @Override
    public void atEndOfRound() {
        if (this.amount == 0) {
            AbstractDungeon.actionManager.addToBottom(new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
        } else {
            AbstractDungeon.actionManager.addToBottom(new ReducePowerAction(this.owner, this.owner, POWER_ID, 1));
        }
    }

    @Override
    public void onRemove() {
        this.flash();
        AbstractDungeon.actionManager.addToTop(new GainEnergyAction(this.energyAmt));
    }

    @Override
    public void stackPower(int stackAmount) {
        this.energyAmt += stackAmount;
    }
}

