/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class ReduceDamagePower
extends AbstractPower {
    public static final String POWER_ID = "Reduce Damage";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Reduce Damage");
    public static final String NAME = ReduceDamagePower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = ReduceDamagePower.powerStrings.DESCRIPTIONS;

    public ReduceDamagePower(AbstractCreature owner, int armorAmt) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = armorAmt;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/exoskeleton.png");
        this.priority = 99;
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0] + this.amount + ".";
    }

    @Override
    public float atDamageReceive(float damage, DamageInfo.DamageType type) {
        if (type != DamageInfo.DamageType.HP_LOSS) {
            this.flash();
            damage -= (float)this.amount;
        }
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        return damage;
    }
}

