/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.actions.common.RelicAboveCreatureAction;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class AncientTeaSet
extends AbstractRelic {
    public static final String ID = "Ancient Tea Set";
    private static final int ENERGY_AMT = 2;
    private boolean isReady = false;
    private boolean firstTurn = true;

    public AncientTeaSet() {
        super(ID, "teaSet.png", AbstractRelic.RelicTier.COMMON, AbstractRelic.LandingSound.SOLID);
    }

    public AncientTeaSet(AbstractPlayer.PlayerClass c) {
        super(ID, "teaSet.png", AbstractRelic.RelicTier.COMMON, AbstractRelic.LandingSound.SOLID);
    }

    @Override
    public String getUpdatedDescription() {
        if (AbstractDungeon.player != null) {
            return this.setDescription(AbstractDungeon.player.chosenClass);
        }
        return this.setDescription(null);
    }

    private String setDescription(AbstractPlayer.PlayerClass c) {
        if (c == null) {
            return this.DESCRIPTIONS[0];
        }
        switch (c) {
            case IRONCLAD: {
                return this.DESCRIPTIONS[0];
            }
            case THE_SILENT: {
                return this.DESCRIPTIONS[1];
            }
            case CROWBOT: {
                return this.DESCRIPTIONS[2];
            }
        }
        return this.DESCRIPTIONS[0];
    }

    @Override
    public void updateDescription(AbstractPlayer.PlayerClass c) {
        this.description = this.setDescription(c);
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    @Override
    public void atTurnStart() {
        if (this.firstTurn) {
            if (this.isReady) {
                this.pulse = false;
                this.isReady = false;
                this.flash();
                AbstractDungeon.actionManager.addToTop(new GainEnergyAction(2));
                AbstractDungeon.actionManager.addToTop(new RelicAboveCreatureAction(AbstractDungeon.player, this));
            }
            this.firstTurn = false;
        }
    }

    @Override
    public void atPreBattle() {
        this.firstTurn = true;
    }

    @Override
    public void onEnterRestRoom() {
        this.flash();
        this.isReady = true;
        this.pulse = true;
    }

    @Override
    public AbstractRelic makeCopy() {
        return new AncientTeaSet();
    }

    @Override
    public AbstractRelic makeCopy(AbstractPlayer.PlayerClass c) {
        return new AncientTeaSet(c);
    }
}

