/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.actions.common.RelicAboveCreatureAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class Dodecahedron
extends AbstractRelic {
    public static final String ID = "Dodecahedron";
    private static final int ENERGY_AMT = 1;

    public Dodecahedron(AbstractPlayer.PlayerClass c) {
        super(ID, "dodecahedron.png", AbstractRelic.RelicTier.UNCOMMON, AbstractRelic.LandingSound.HEAVY);
    }

    @Override
    public String getUpdatedDescription() {
        if (AbstractDungeon.player != null) {
            return this.setDescription(AbstractDungeon.player.chosenClass);
        }
        return this.setDescription(null);
    }

    private String setDescription(AbstractPlayer.PlayerClass c) {
        if (c == null) {
            return this.DESCRIPTIONS[0] + this.DESCRIPTIONS[1];
        }
        switch (c) {
            case IRONCLAD: {
                return this.DESCRIPTIONS[0] + this.DESCRIPTIONS[1];
            }
            case THE_SILENT: {
                return this.DESCRIPTIONS[0] + this.DESCRIPTIONS[2];
            }
            case CROWBOT: {
                return this.DESCRIPTIONS[0] + this.DESCRIPTIONS[3];
            }
        }
        return this.DESCRIPTIONS[0] + this.DESCRIPTIONS[1];
    }

    @Override
    public void updateDescription(AbstractPlayer.PlayerClass c) {
        this.description = this.setDescription(c);
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    @Override
    public void atBattleStart() {
        this.controlPulse();
    }

    @Override
    public void onVictory() {
        this.stopPulse();
    }

    @Override
    public void atTurnStart() {
        AbstractDungeon.actionManager.addToBottom(new AbstractGameAction(){

            @Override
            public void update() {
                if (Dodecahedron.this.isActive()) {
                    Dodecahedron.this.flash();
                    AbstractDungeon.actionManager.addToBottom(new RelicAboveCreatureAction(AbstractDungeon.player, Dodecahedron.this));
                    AbstractDungeon.actionManager.addToBottom(new GainEnergyAction(1));
                }
                this.isDone = true;
            }
        });
    }

    @Override
    public int onPlayerHeal(int healAmount) {
        this.controlPulse();
        return super.onPlayerHeal(healAmount);
    }

    @Override
    public int onAttacked(DamageInfo info, int damageAmount) {
        if (damageAmount > 0) {
            this.stopPulse();
        }
        return super.onAttacked(info, damageAmount);
    }

    @Override
    public AbstractRelic makeCopy() {
        if (AbstractDungeon.player == null) {
            return new Dodecahedron(AbstractPlayer.PlayerClass.IRONCLAD);
        }
        return new Dodecahedron(AbstractDungeon.player.chosenClass);
    }

    private boolean isActive() {
        return AbstractDungeon.player.currentHealth >= AbstractDungeon.player.maxHealth;
    }

    private void controlPulse() {
        if (this.isActive()) {
            this.beginLongPulse();
        } else {
            this.stopPulse();
        }
    }

    @Override
    public AbstractRelic makeCopy(AbstractPlayer.PlayerClass chosenClass) {
        return new Dodecahedron(chosenClass);
    }
}

