/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class NullstonePeriapt
extends AbstractRelic {
    public static final String ID = "Nullstone Periapt";
    private static final int NUM_TURNS = 10;

    public NullstonePeriapt() {
        super(ID, "nullStone.png", AbstractRelic.RelicTier.RARE, AbstractRelic.LandingSound.MAGICAL);
        this.pulse = false;
    }

    @Override
    public String getUpdatedDescription() {
        return this.DESCRIPTIONS[0];
    }

    @Override
    public void onEquip() {
        this.counter = -1;
    }

    @Override
    public void atTurnStart() {
        if (this.counter != -1) {
            this.pulse = false;
            ++this.counter;
        }
        if (this.counter == 10) {
            this.counter = -1;
            this.img = ImageMaster.loadImage("images/relics/nullStone.png");
            this.flash();
            if (!this.pulse) {
                this.beginPulse();
                this.pulse = true;
            }
        }
    }

    @Override
    public void atPreBattle() {
        if (this.counter == -1) {
            this.beginPulse();
            this.pulse = true;
        }
    }

    @Override
    public void onVictory() {
        this.pulse = false;
    }

    @Override
    public void setCounter(int counter) {
        this.counter = counter;
        this.img = counter != -1 ? ImageMaster.loadImage("images/relics/nullStoneUsed.png") : ImageMaster.loadImage("images/relics/nullStone.png");
    }

    @Override
    public AbstractRelic makeCopy() {
        return new NullstonePeriapt();
    }
}

