/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.actions.common.DrawCardAction;
import com.megacrit.cardcrawl.actions.common.RelicAboveCreatureAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.AbstractRoom;

public class RunicCube
extends AbstractRelic {
    public static final String ID = "Runic Cube";
    private static final int NUM_CARDS = 1;
    private static final float HP_LOSS = 0.8f;
    private static final int HP_LOSS_PERCENT = 20;
    private int hpLoss = 0;

    public RunicCube() {
        super(ID, "runicCube.png", AbstractRelic.RelicTier.BOSS, AbstractRelic.LandingSound.FLAT);
    }

    @Override
    public String getUpdatedDescription() {
        return this.DESCRIPTIONS[0] + 20 + this.DESCRIPTIONS[1] + 1 + this.DESCRIPTIONS[2];
    }

    @Override
    public void onEquip() {
        int before = AbstractDungeon.player.maxHealth;
        AbstractDungeon.player.maxHealth = (int)((float)AbstractDungeon.player.maxHealth * 0.8f);
        this.hpLoss = before - AbstractDungeon.player.maxHealth;
        if (AbstractDungeon.player.currentHealth > AbstractDungeon.player.maxHealth) {
            AbstractDungeon.player.currentHealth = AbstractDungeon.player.maxHealth;
        }
    }

    @Override
    public void onUnequip() {
        AbstractDungeon.player.increaseMaxHp(this.hpLoss, false);
    }

    @Override
    public int onAttacked(DamageInfo info, int damageAmount) {
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT && damageAmount > 0) {
            this.flash();
            AbstractDungeon.actionManager.addToTop(new DrawCardAction(AbstractDungeon.player, 1));
            AbstractDungeon.actionManager.addToTop(new RelicAboveCreatureAction(AbstractDungeon.player, this));
        }
        return damageAmount;
    }

    @Override
    public AbstractRelic makeCopy() {
        return new RunicCube();
    }
}

