/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.rewards;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.MonsterRoomBoss;
import com.megacrit.cardcrawl.rooms.TreasureRoom;
import com.megacrit.cardcrawl.ui.FtueTip;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.RewardGlowEffect;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardItem {
    private static final Logger logger = LogManager.getLogger(RewardItem.class.getName());
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Potion Tip");
    public static final String[] MSG = RewardItem.tutorialStrings.TEXT;
    public static final String[] LABEL = RewardItem.tutorialStrings.LABEL;
    public RewardType type;
    public int goldAmt = 0;
    public int bonusGold = 0;
    public String text;
    public AbstractRelic relic;
    public AbstractPotion potion;
    private ArrayList<AbstractCard> cards;
    private ArrayList<AbstractGameEffect> effects = new ArrayList();
    private boolean isBoss;
    public Hitbox hb = new Hitbox(460.0f * Settings.scale, 90.0f * Settings.scale);
    public float y;
    public boolean isDone = false;
    private static final int ITEM_W = 464;
    private static final int ITEM_H = 98;
    public static final float REWARD_ITEM_X = 786.0f * Settings.scale;
    private static final float REWARD_TEXT_X = 833.0f * Settings.scale;

    public RewardItem(int gold) {
        this.type = RewardType.GOLD;
        this.goldAmt = gold;
        this.applyGoldBonus(false);
    }

    public RewardItem(int gold, boolean theft) {
        this.type = RewardType.STOLEN_GOLD;
        this.goldAmt = gold;
        this.applyGoldBonus(theft);
    }

    private void applyGoldBonus(boolean theft) {
        int tmp = this.goldAmt;
        this.bonusGold = 0;
        if (theft) {
            this.text = this.goldAmt + " Gold (Stolen Back)";
        } else {
            if (AbstractDungeon.player.hasRelic("Golden Idol") && !(AbstractDungeon.getCurrRoom() instanceof TreasureRoom)) {
                this.bonusGold += MathUtils.round((float)tmp * 0.25f);
            }
            this.text = this.bonusGold == 0 ? this.goldAmt + " Gold" : this.goldAmt + " Gold   (+" + this.bonusGold + ")";
        }
    }

    public RewardItem(AbstractRelic relic) {
        this.type = RewardType.RELIC;
        this.relic = relic;
        relic.hitbox = new Hitbox(80.0f * Settings.scale, 80.0f * Settings.scale);
        relic.hitbox.move(-1000.0f, -1000.0f);
        this.text = relic.name;
    }

    public RewardItem(AbstractPotion potion) {
        this.type = RewardType.POTION;
        this.potion = potion;
        this.text = potion.name;
    }

    public RewardItem() {
        this.type = RewardType.CARD;
        this.isBoss = AbstractDungeon.getCurrRoom() instanceof MonsterRoomBoss;
        this.cards = AbstractDungeon.getRewardCards();
        this.text = "Add a card to your deck";
    }

    public void incrementGold(int gold) {
        if (this.type == RewardType.GOLD) {
            this.goldAmt += gold;
            this.applyGoldBonus(false);
        } else if (this.type == RewardType.STOLEN_GOLD) {
            this.goldAmt += gold;
            this.applyGoldBonus(true);
        } else {
            logger.info("ERROR: Using increment() wrong for RewardItem");
        }
    }

    public void move(float y) {
        this.y = y;
        this.hb.move((float)Settings.WIDTH / 2.0f, y);
        if (this.type == RewardType.POTION) {
            this.potion.moveInstantly(REWARD_ITEM_X, y);
        } else if (this.type == RewardType.RELIC) {
            this.relic.currentX = REWARD_ITEM_X;
            this.relic.currentY = y;
            this.relic.targetX = REWARD_ITEM_X;
            this.relic.targetY = y;
        }
    }

    public void update() {
        this.hb.update();
        if (this.effects.size() == 0) {
            this.effects.add(new RewardGlowEffect(this.hb.cX, this.hb.cY));
        }
        Iterator<AbstractGameEffect> i = this.effects.iterator();
        while (i.hasNext()) {
            AbstractGameEffect e = i.next();
            e.update();
            if (!e.isDone) continue;
            i.remove();
        }
        if (this.hb.hovered) {
            switch (this.type) {
                case POTION: {
                    if (AbstractDungeon.topPanel.potionCombine) break;
                    TipHelper.renderGenericTip((float)InputHelper.mX + 50.0f * Settings.scale, InputHelper.mY, this.potion.name, this.potion.description);
                    break;
                }
                case RELIC: {
                    break;
                }
            }
        }
        if (this.hb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
        if (this.hb.hovered && InputHelper.justClickedLeft && !this.isDone) {
            CardCrawlGame.sound.playA("UI_CLICK_1", 0.1f);
            this.hb.clickStarted = true;
        }
        if (this.hb.clicked) {
            this.hb.clicked = false;
            this.isDone = true;
        }
    }

    public boolean claimReward() {
        switch (this.type) {
            case GOLD: {
                CardCrawlGame.sound.play("GOLD_GAIN");
                if (this.bonusGold == 0) {
                    AbstractDungeon.player.gainGold(this.goldAmt);
                } else {
                    AbstractDungeon.player.gainGold(this.goldAmt + this.bonusGold);
                }
                return true;
            }
            case STOLEN_GOLD: {
                CardCrawlGame.sound.play("GOLD_GAIN");
                if (this.bonusGold == 0) {
                    AbstractDungeon.player.gainGold(this.goldAmt);
                } else {
                    AbstractDungeon.player.gainGold(this.goldAmt + this.bonusGold);
                }
                return true;
            }
            case POTION: {
                for (int i = 0; i < 3; ++i) {
                    if (!(AbstractDungeon.player.potions[i] instanceof PotionPlaceholder)) continue;
                    CardCrawlGame.sound.play("POTION_1");
                    this.potion.moveInstantly(AbstractDungeon.player.potions[i].currentX, AbstractDungeon.player.potions[i].currentY);
                    this.potion.isObtained = true;
                    this.potion.isDone = true;
                    this.potion.isAnimating = false;
                    this.potion.flash();
                    AbstractDungeon.player.potions[i] = this.potion;
                    if (!TipTracker.tips.get("POTION_TIP").booleanValue()) {
                        AbstractDungeon.ftue = new FtueTip(LABEL[0], MSG[0], (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, this.potion);
                        TipTracker.neverShowAgain("POTION_TIP");
                    }
                    return true;
                }
                return false;
            }
            case RELIC: {
                if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GRID) {
                    return false;
                }
                this.relic.instantObtain(false);
                return true;
            }
            case CARD: {
                if (AbstractDungeon.player.hasRelic("Question Card")) {
                    AbstractDungeon.player.getRelic("Question Card").flash();
                }
                if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD) {
                    AbstractDungeon.cardRewardScreen.open(this.cards, this, "Choose a Card");
                    AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
                }
                return false;
            }
        }
        logger.info("ERROR: Claim Reward() failed");
        return false;
    }

    public void render(SpriteBatch sb) {
        Color color;
        if (this.hb.hovered) {
            sb.setColor(new Color(0.4f, 0.6f, 0.6f, 1.0f));
        } else {
            sb.setColor(new Color(0.5f, 0.6f, 0.6f, 0.8f));
        }
        if (this.hb.clickStarted) {
            sb.draw(ImageMaster.REWARD_SCREEN_ITEM, (float)Settings.WIDTH / 2.0f - 232.0f, this.y - 49.0f, 232.0f, 49.0f, 464.0f, 98.0f, Settings.scale * 0.98f, Settings.scale * 0.98f, 0.0f, 0, 0, 464, 98, false, false);
        } else {
            sb.draw(ImageMaster.REWARD_SCREEN_ITEM, (float)Settings.WIDTH / 2.0f - 232.0f, this.y - 49.0f, 232.0f, 49.0f, 464.0f, 98.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 464, 98, false, false);
        }
        sb.setColor(Color.WHITE);
        switch (this.type) {
            case CARD: {
                if (this.isBoss) {
                    sb.draw(ImageMaster.REWARD_CARD_BOSS, REWARD_ITEM_X - 32.0f, this.y - 32.0f - 2.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 64, 64, false, false);
                    break;
                }
                sb.draw(ImageMaster.REWARD_CARD_NORMAL, REWARD_ITEM_X - 32.0f, this.y - 32.0f - 2.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 64, 64, false, false);
                break;
            }
            case GOLD: {
                sb.draw(ImageMaster.UI_GOLD, REWARD_ITEM_X - 32.0f, this.y - 32.0f - 2.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 64, 64, false, false);
                break;
            }
            case STOLEN_GOLD: {
                sb.draw(ImageMaster.UI_GOLD, REWARD_ITEM_X - 32.0f, this.y - 32.0f - 2.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 64, 64, false, false);
                break;
            }
            case RELIC: {
                this.relic.renderOutline(sb);
                this.relic.render(sb);
                if (!this.hb.hovered || !Settings.RELIC_TIP) break;
                this.relic.renderTip(sb);
                break;
            }
            case POTION: {
                this.potion.renderLightOutline(sb);
                this.potion.render(sb);
                break;
            }
        }
        if (this.hb.hovered) {
            color = Settings.GOLD_COLOR;
            FontHelper.renderSmartText(sb, FontHelper.rewardTipFont, this.text, REWARD_TEXT_X, this.y + 5.0f * Settings.scale, 1000.0f * Settings.scale, 0.0f, color);
        } else {
            color = Settings.CREAM_COLOR;
            FontHelper.renderSmartText(sb, FontHelper.rewardTipFont, this.text, REWARD_TEXT_X, this.y + 5.0f * Settings.scale, 1000.0f * Settings.scale, 0.0f, color);
        }
        if (!this.hb.hovered) {
            for (AbstractGameEffect e : this.effects) {
                e.render(sb);
            }
        }
        this.hb.render(sb);
    }

    public static enum RewardType {
        CARD,
        GOLD,
        RELIC,
        POTION,
        STOLEN_GOLD;

    }
}

