/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.rooms;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.ClearCardQueueAction;
import com.megacrit.cardcrawl.actions.GameActionManager;
import com.megacrit.cardcrawl.actions.common.DiscardAtEndOfTurnAction;
import com.megacrit.cardcrawl.actions.common.DrawCardAction;
import com.megacrit.cardcrawl.actions.common.EnableEndTurnButtonAction;
import com.megacrit.cardcrawl.actions.common.EndTurnAction;
import com.megacrit.cardcrawl.actions.common.GainEnergyAndEnableControlsAction;
import com.megacrit.cardcrawl.actions.common.MonsterStartTurnAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.SoulGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.dungeons.TheBeyond;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.AbstractTextEvent;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.ScrollInputProcessor;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rooms.EventRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoomBoss;
import com.megacrit.cardcrawl.rooms.MonsterRoomElite;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.rooms.VictoryRoom;
import com.megacrit.cardcrawl.ui.buttons.CancelButton;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import com.megacrit.cardcrawl.vfx.combat.BattleStartEffect;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRoom {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("AbstractRoom");
    public static final String[] TEXT = AbstractRoom.uiStrings.TEXT;
    private static final Logger logger = LogManager.getLogger(AbstractRoom.class.getName());
    public ArrayList<AbstractPotion> potions = new ArrayList();
    public ArrayList<AbstractRelic> relics = new ArrayList();
    public ArrayList<RewardItem> rewards = new ArrayList();
    public SoulGroup souls = new SoulGroup();
    public RoomPhase phase;
    public String description;
    public AbstractEvent event = null;
    public MonsterGroup monsters;
    public String roomHoverMsg = null;
    public static final float healVariability = 0.33f;
    private float endBattleTimer = 0.0f;
    public float rewardPopOutTimer = 1.0f;
    private static final float END_TURN_WAIT_DURATION = 1.2f;
    protected String mapSymbol;
    protected Texture mapImg;
    protected Texture mapImgOutline;
    public boolean isBattleOver = false;
    public boolean cannotLose = false;
    public boolean eliteTrigger = false;
    public static int blizzardPotionMod = 0;
    private static final int BLIZZARD_POTION_MOD_AMT = 10;
    public boolean mugged = false;
    public static float waitTimer = 0.0f;

    public final Texture getMapImg() {
        return this.mapImg;
    }

    public final Texture getMapImgOutline() {
        return this.mapImgOutline;
    }

    public final void setMapImg(Texture img, Texture imgOutline) {
        this.mapImg = img;
        this.mapImgOutline = imgOutline;
    }

    public abstract void onPlayerEntry();

    public void playBGM(String key) {
        CardCrawlGame.music.playTempBGM(key);
    }

    public void playBgmInstantly(String key) {
        CardCrawlGame.music.playTempBgmInstantly(key);
    }

    public final String getMapSymbol() {
        return this.mapSymbol;
    }

    public final void setMapSymbol(String newSymbol) {
        this.mapSymbol = newSymbol;
    }

    public abstract AbstractCard.CardRarity getCardRarity(int var1);

    public void updateObjects() {
        this.souls.update();
        Iterator<Object> i = this.potions.iterator();
        while (i.hasNext()) {
            AbstractPotion item = i.next();
            item.update();
            if (!item.isDone) continue;
            i.remove();
        }
        i = this.relics.iterator();
        while (i.hasNext()) {
            AbstractRelic relic = (AbstractRelic)i.next();
            relic.update();
            if (!relic.isDone) continue;
            i.remove();
        }
    }

    public void update() {
        if (!AbstractDungeon.isScreenUp && InputHelper.pressedEscape && AbstractDungeon.overlayMenu.cancelButton.current_x == CancelButton.HIDE_X) {
            AbstractDungeon.settingsScreen.open();
        }
        if (InputHelper.justClickedRight && Settings.isDebug) {
            AbstractDungeon.scene.randomizeScene();
        }
        if (Settings.isDebug && Gdx.input.isKeyJustPressed(35)) {
            AbstractDungeon.player.gainGold(100);
        }
        switch (this.phase) {
            case EVENT: {
                break;
            }
            case COMBAT: {
                this.monsters.update();
                if (waitTimer > 0.0f) {
                    if (AbstractDungeon.actionManager.currentAction != null || !AbstractDungeon.actionManager.isEmpty()) {
                        AbstractDungeon.actionManager.update();
                    } else {
                        waitTimer -= Gdx.graphics.getDeltaTime();
                    }
                    if (waitTimer <= 0.0f) {
                        AbstractDungeon.actionManager.turnHasEnded = true;
                        if (!AbstractDungeon.isScreenUp) {
                            AbstractDungeon.topLevelEffects.add(new BattleStartEffect(false));
                        }
                        AbstractDungeon.actionManager.addToBottom(new GainEnergyAndEnableControlsAction(AbstractDungeon.player.energy.redMaster, AbstractDungeon.player.energy.greenMaster, AbstractDungeon.player.energy.blueMaster));
                        AbstractDungeon.actionManager.addToBottom(new DrawCardAction(AbstractDungeon.player, AbstractDungeon.player.gameHandSize));
                        AbstractDungeon.actionManager.addToBottom(new EnableEndTurnButtonAction());
                        AbstractDungeon.overlayMenu.showCombatPanels();
                        AbstractDungeon.player.applyStartOfCombatLogic();
                        AbstractDungeon.player.applyStartOfTurnRelics();
                        AbstractDungeon.player.applyStartOfTurnCards();
                        AbstractDungeon.player.applyStartOfTurnPowers();
                        AbstractDungeon.actionManager.useNextCombatActions();
                    }
                } else {
                    if (Settings.isDebug && Gdx.input.isKeyJustPressed(62)) {
                        AbstractDungeon.actionManager.addToTop(new DrawCardAction(AbstractDungeon.player, 1));
                    }
                    if (!AbstractDungeon.isScreenUp) {
                        AbstractDungeon.actionManager.update();
                        if (!this.monsters.areMonstersBasicallyDead() && AbstractDungeon.player.currentHealth > 0) {
                            AbstractDungeon.player.updateInput();
                        }
                    }
                    if (!AbstractDungeon.screen.equals((Object)AbstractDungeon.CurrentScreen.HAND_SELECT)) {
                        AbstractDungeon.player.combatUpdate();
                    }
                    if (AbstractDungeon.player.isEndingTurn) {
                        this.endTurn();
                    }
                }
                if (this.isBattleOver) {
                    this.endBattleTimer -= Gdx.graphics.getDeltaTime();
                    if (this.endBattleTimer < 0.0f) {
                        this.phase = RoomPhase.COMPLETE;
                        if (!(AbstractDungeon.getCurrRoom() instanceof MonsterRoomBoss) || !(CardCrawlGame.dungeon instanceof TheBeyond)) {
                            CardCrawlGame.sound.play("VICTORY");
                        }
                        this.endBattleTimer = 0.0f;
                        if (this instanceof MonsterRoomBoss) {
                            if (Settings.isDailyRun) {
                                this.addGoldToRewards(100);
                            } else {
                                this.addGoldToRewards(100 + MathUtils.random(-5, 5));
                            }
                            if (DailyMods.mods.get("Cursed Run").booleanValue()) {
                                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.returnRandomCurse(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                            }
                        } else if (this instanceof MonsterRoomElite) {
                            System.out.println("ELITES SLAIN " + ++CardCrawlGame.elitesSlain);
                            if (Settings.isDailyRun) {
                                this.addGoldToRewards(30);
                            } else {
                                this.addGoldToRewards(MathUtils.random(25, 35));
                            }
                        } else if (this instanceof MonsterRoom && !AbstractDungeon.getMonsters().haveMonstersEscaped()) {
                            System.out.println("MONSTERS SLAIN " + ++CardCrawlGame.monstersSlain);
                            if (Settings.isDailyRun) {
                                this.addGoldToRewards(15);
                            } else {
                                this.addGoldToRewards(MathUtils.random(10, 20));
                            }
                        }
                        if (!(AbstractDungeon.getCurrRoom() instanceof MonsterRoomBoss) || !(CardCrawlGame.dungeon instanceof TheBeyond)) {
                            this.dropReward();
                            this.addPotionToRewards();
                            if (!this.mugged) {
                                AbstractDungeon.combatRewardScreen.open();
                            } else {
                                AbstractDungeon.combatRewardScreen.openCombat(TEXT[0]);
                            }
                        }
                    }
                }
                this.monsters.updateAnimations();
                break;
            }
            case COMPLETE: {
                if (AbstractDungeon.isScreenUp) break;
                AbstractDungeon.actionManager.update();
                if (!AbstractDungeon.actionManager.isEmpty() || AbstractDungeon.isFadingOut) break;
                if (this.rewardPopOutTimer > 1.0f) {
                    this.rewardPopOutTimer = 1.0f;
                }
                this.rewardPopOutTimer -= Gdx.graphics.getDeltaTime();
                if (!(this.rewardPopOutTimer < 0.0f)) break;
                if (this.event == null) {
                    AbstractDungeon.overlayMenu.proceedButton.show();
                    break;
                }
                if (this.event instanceof AbstractTextEvent || this.event instanceof AbstractImageEvent || this.event.hasFocus) break;
                AbstractDungeon.overlayMenu.proceedButton.show();
                break;
            }
            case INCOMPLETE: {
                break;
            }
            default: {
                logger.info("MISSING PHASE, bro");
            }
        }
        AbstractDungeon.player.update();
        AbstractDungeon.player.updateAnimations();
    }

    public void endTurn() {
        this.applyEndOfTurnRelics();
        AbstractDungeon.player.applyEndOfTurnTriggers();
        AbstractDungeon.actionManager.addToBottom(new ClearCardQueueAction());
        AbstractDungeon.actionManager.addToBottom(new DiscardAtEndOfTurnAction());
        for (AbstractCard c : AbstractDungeon.player.drawPile.group) {
            c.resetAttributes();
        }
        for (AbstractCard c : AbstractDungeon.player.discardPile.group) {
            c.resetAttributes();
        }
        for (AbstractCard c : AbstractDungeon.player.hand.group) {
            c.resetAttributes();
        }
        if (AbstractDungeon.player.hoveredCard != null) {
            AbstractDungeon.player.hoveredCard.resetAttributes();
        }
        AbstractDungeon.actionManager.addToBottom(new AbstractGameAction(){

            @Override
            public void update() {
                AbstractDungeon.actionManager.addToBottom(new EndTurnAction());
                if (!CardCrawlGame.fastMode) {
                    AbstractDungeon.actionManager.addToBottom(new WaitAction(1.2f));
                }
                AbstractDungeon.actionManager.addToBottom(new MonsterStartTurnAction());
                AbstractDungeon.actionManager.monsterAttacksQueued = false;
                this.isDone = true;
            }
        });
        AbstractDungeon.player.isEndingTurn = false;
    }

    public void endBattle() {
        this.isBattleOver = true;
        if (AbstractDungeon.player.currentHealth == 1) {
            UnlockTracker.unlockAchievement("SHRUG_IT_OFF");
        }
        if (AbstractDungeon.player.hasRelic("Meat on the Bone")) {
            AbstractDungeon.player.getRelic("Meat on the Bone").onTrigger();
        }
        AbstractDungeon.player.onVictory();
        this.endBattleTimer = !CardCrawlGame.fastMode ? 1.0f : 0.1f;
        int attackCount = 0;
        int skillCount = 0;
        for (AbstractCard c : AbstractDungeon.actionManager.cardsPlayedThisCombat) {
            if (c.type == AbstractCard.CardType.ATTACK) {
                ++attackCount;
                break;
            }
            if (c.type != AbstractCard.CardType.SKILL) continue;
            ++skillCount;
        }
        if (attackCount == 0) {
            UnlockTracker.unlockAchievement("COME_AT_ME");
        }
        if (skillCount == 0) {
            // empty if block
        }
        CardCrawlGame.metricData.addEncounterData();
        AbstractDungeon.actionManager.clear();
        AbstractDungeon.player.inSingleTargetMode = false;
        AbstractDungeon.player.releaseCard();
        AbstractDungeon.player.hand.refreshHandLayout();
        AbstractDungeon.overlayMenu.hideCombatPanels();
    }

    public void dropReward() {
    }

    public void render(SpriteBatch sb) {
        if (this instanceof EventRoom || this instanceof VictoryRoom) {
            if (this.event != null && !(this.event instanceof AbstractTextEvent) && !(this.event instanceof AbstractImageEvent)) {
                this.event.renderRoomEventPanel(sb);
                AbstractDungeon.player.render(sb);
            }
        } else if (AbstractDungeon.screen != AbstractDungeon.CurrentScreen.BOSS_REWARD) {
            AbstractDungeon.player.render(sb);
        }
        if (!(AbstractDungeon.getCurrRoom() instanceof RestRoom)) {
            if (this.monsters != null && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.DEATH) {
                this.monsters.render(sb);
            }
            if (this.phase == RoomPhase.COMBAT) {
                AbstractDungeon.player.renderPlayerBattleUi(sb);
            }
            for (AbstractPotion i : this.potions) {
                if (i.isObtained) continue;
                i.render(sb);
            }
        }
        for (AbstractRelic r : this.relics) {
            r.render(sb);
        }
        this.renderTips(sb);
    }

    public void renderAboveTopPanel(SpriteBatch sb) {
        for (AbstractPotion i : this.potions) {
            if (!i.isObtained) continue;
            i.render(sb);
        }
        this.souls.render(sb);
        if (Settings.isInfo) {
            StringBuilder strb = new StringBuilder("");
            strb.append("Last Pressed Key:\n");
            strb.append(ScrollInputProcessor.lastPressed);
            strb.append("\n" + ScrollInputProcessor.lastPressed2);
            strb.append("\n\nDeck: ");
            strb.append(AbstractDungeon.player.masterDeck.size());
            strb.append("\nDraw Pile:   ");
            strb.append(AbstractDungeon.player.drawPile.size());
            strb.append("\nDiscard Pile: ");
            strb.append(AbstractDungeon.player.discardPile.size());
            strb.append("\nExhaust Pile: ");
            strb.append(AbstractDungeon.player.exhaustPile.size());
            strb.append("\n\n[Action Manager]");
            strb.append("\n DamageThisTurn: " + GameActionManager.damageReceivedThisTurn);
            strb.append("\n DamageThisCombat: " + GameActionManager.damageReceivedThisCombat);
            strb.append("\n Phase: ");
            strb.append(AbstractDungeon.actionManager.phase.name());
            strb.append("\n cardsPlayed (turn):   ");
            strb.append(AbstractDungeon.actionManager.cardsPlayedThisTurn.size());
            strb.append("\n cardsPlayed (combat): ");
            strb.append(AbstractDungeon.actionManager.cardsPlayedThisCombat.size());
            strb.append("\n turnEnded: ");
            strb.append(AbstractDungeon.actionManager.turnHasEnded);
            strb.append("\n numTurns: ");
            strb.append(GameActionManager.turn);
            strb.append("\n\n[Misc]");
            strb.append("\nisFadingOut: ");
            strb.append(AbstractDungeon.isFadingOut);
            strb.append("\nParticles: " + AbstractDungeon.effectList.size());
            strb.append("\nPotions: " + this.potions.size());
            strb.append("\nPotion[1]: " + AbstractDungeon.player.potions[0].name);
            strb.append("\nPotion[2]: " + AbstractDungeon.player.potions[1].name);
            strb.append("\nPotion[3]: " + AbstractDungeon.player.potions[2].name);
            FontHelper.renderFontCenteredHeight(sb, FontHelper.panelInfoFont, strb.toString(), 30.0f, (float)Settings.HEIGHT * 0.55f, Color.WHITE);
        }
    }

    public void renderTips(SpriteBatch sb) {
    }

    public void spawnRelicAndObtain(float x, float y, AbstractRelic relic) {
        relic.spawn(x, y);
        this.relics.add(relic);
        relic.obtain();
        relic.isObtained = true;
        relic.isAnimating = false;
        relic.isDone = false;
        relic.flash();
    }

    private void applyEndOfTurnRelics() {
        for (AbstractRelic r : AbstractDungeon.player.relics) {
            r.onPlayerEndTurn();
        }
    }

    public void addRelicToRewards(AbstractRelic.RelicTier tier) {
        this.rewards.add(new RewardItem(AbstractDungeon.returnRandomRelic(tier)));
    }

    public void addRelicToRewards(AbstractRelic relic) {
        this.rewards.add(new RewardItem(relic));
    }

    public void addPotionToRewards(AbstractPotion potion) {
        this.rewards.add(new RewardItem(potion));
    }

    public void addCardToRewards() {
        this.rewards.add(new RewardItem());
    }

    public void addPotionToRewards() {
        int chance = 0;
        if (this instanceof MonsterRoomElite) {
            chance = 40;
            chance += blizzardPotionMod;
        } else if (this instanceof MonsterRoom) {
            if (!AbstractDungeon.getMonsters().haveMonstersEscaped()) {
                chance = 40;
                chance += blizzardPotionMod;
            }
        } else if (this instanceof MonsterRoomBoss) {
            chance = 0;
        } else if (this instanceof EventRoom) {
            chance = 40;
            chance += blizzardPotionMod;
        }
        if (AbstractDungeon.player.hasRelic("White Beast Statue")) {
            chance = 100;
        }
        logger.info("POTION CHANCE: " + chance);
        if (AbstractDungeon.potionRng.random(0, 99) < chance || Settings.isDebug) {
            CardCrawlGame.metricData.potions_floor_spawned.add(AbstractDungeon.floorNum);
            this.rewards.add(new RewardItem(AbstractDungeon.returnRandomPotion()));
            blizzardPotionMod -= 10;
        } else {
            blizzardPotionMod += 10;
        }
    }

    public void addGoldToRewards(int gold) {
        for (RewardItem i : this.rewards) {
            if (i.type != RewardItem.RewardType.GOLD) continue;
            i.incrementGold(gold);
            return;
        }
        this.rewards.add(new RewardItem(gold));
    }

    public void addStolenGoldToRewards(int gold) {
        for (RewardItem i : this.rewards) {
            if (i.type != RewardItem.RewardType.STOLEN_GOLD) continue;
            i.incrementGold(gold);
            return;
        }
        this.rewards.add(new RewardItem(gold, true));
    }

    public boolean isBattleEnding() {
        if (this.isBattleOver) {
            return true;
        }
        if (this.monsters != null) {
            return this.monsters.areMonstersBasicallyDead();
        }
        return false;
    }

    public static enum RoomType {
        SHOP,
        MONSTER,
        SHRINE,
        TREASURE,
        EVENT,
        BOSS;

    }

    public static enum RoomPhase {
        COMBAT,
        EVENT,
        COMPLETE,
        INCOMPLETE;

    }
}

