/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.rooms;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.ui.campfire.AbstractCampfireOption;
import com.megacrit.cardcrawl.ui.campfire.DigOption;
import com.megacrit.cardcrawl.ui.campfire.LiftOption;
import com.megacrit.cardcrawl.ui.campfire.RestOption;
import com.megacrit.cardcrawl.ui.campfire.SmithOption;
import com.megacrit.cardcrawl.ui.campfire.TokeOption;
import com.megacrit.cardcrawl.vfx.BobEffect;
import com.megacrit.cardcrawl.vfx.campfire.CampfireBubbleEffect;
import com.megacrit.cardcrawl.vfx.campfire.CampfireBurningEffect;
import java.util.ArrayList;
import java.util.Iterator;

public class CampfireUI {
    public static boolean hidden = false;
    public boolean somethingSelected = false;
    private float hideStuffTimer = 0.5f;
    private float charAnimTimer = 2.0f;
    private static final float HIDE_TIME = 0.5f;
    private ArrayList<AbstractCampfireOption> buttons = new ArrayList();
    private ArrayList<CampfireBubbleEffect> bubbles = new ArrayList();
    private float fireTimer = 0.0f;
    private static final float FIRE_INTERVAL = 0.05f;
    private ArrayList<CampfireBurningEffect> fires = new ArrayList();
    private int bubbleAmt;
    private String bubbleMsg;
    private BobEffect effect = new BobEffect(2.0f);

    public CampfireUI() {
        hidden = false;
        this.initializeButtons();
        this.bubbleAmt = this.buttons.size() > 2 ? 60 : 40;
        this.bubbleMsg = this.getCampMessage();
    }

    private void initializeButtons() {
        this.buttons.add(new RestOption());
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                this.buttons.add(new SmithOption(AbstractDungeon.player.masterDeck.getUpgradableCards().size() > 0));
                break;
            }
            case THE_SILENT: {
                this.buttons.add(new SmithOption(AbstractDungeon.player.masterDeck.getUpgradableCards().size() > 0));
                break;
            }
            case CROWBOT: {
                this.buttons.add(new SmithOption(AbstractDungeon.player.masterDeck.getUpgradableCards().size() > 0));
            }
        }
        if (AbstractDungeon.player.hasRelic("Peace Pipe")) {
            this.buttons.add(new TokeOption());
        }
        if (AbstractDungeon.player.hasRelic("Shovel")) {
            this.buttons.add(new DigOption());
        }
        if (AbstractDungeon.player.hasRelic("Girya") && AbstractDungeon.player.getRelic((String)"Girya").counter != 3) {
            this.buttons.add(new LiftOption());
        }
        this.buttons.get(0).setPosition(800.0f * Settings.scale, 720.0f * Settings.scale);
        this.buttons.get(1).setPosition(1110.0f * Settings.scale, 720.0f * Settings.scale);
        if (this.buttons.size() == 3) {
            this.buttons.get(2).setPosition(950.0f * Settings.scale, 450.0f * Settings.scale);
        } else if (this.buttons.size() == 4) {
            this.buttons.get(2).setPosition(800.0f * Settings.scale, 450.0f * Settings.scale);
            this.buttons.get(3).setPosition(1110.0f * Settings.scale, 450.0f * Settings.scale);
        }
    }

    public void update() {
        this.updateCharacterPosition();
        this.effect.update();
        if (!hidden) {
            this.updateBubbles();
            this.updateFire();
            for (AbstractCampfireOption o : this.buttons) {
                o.update();
            }
        }
        if (this.somethingSelected) {
            this.hideStuffTimer -= Gdx.graphics.getDeltaTime();
            if (this.hideStuffTimer < 0.0f) {
                hidden = true;
            }
        }
    }

    private void updateCharacterPosition() {
        this.charAnimTimer -= Gdx.graphics.getDeltaTime();
        if (this.charAnimTimer < 0.0f) {
            this.charAnimTimer = 0.0f;
        }
        AbstractDungeon.player.animX = Interpolation.exp10In.apply(0.0f, -300.0f * Settings.scale, this.charAnimTimer / 2.0f);
    }

    private void updateBubbles() {
        if (this.bubbles.size() < this.bubbleAmt) {
            int s = this.bubbleAmt - this.bubbles.size();
            for (int i = 0; i < s; ++i) {
                this.bubbles.add(new CampfireBubbleEffect(this.bubbleAmt == 60));
            }
        }
        Iterator<CampfireBubbleEffect> i = this.bubbles.iterator();
        while (i.hasNext()) {
            CampfireBubbleEffect bubble = i.next();
            bubble.update();
            if (!bubble.isDone) continue;
            i.remove();
        }
    }

    private void updateFire() {
        this.fireTimer -= Gdx.graphics.getDeltaTime();
        if (this.fireTimer < 0.0f) {
            this.fireTimer = 0.05f;
            this.fires.add(new CampfireBurningEffect());
            this.fires.add(new CampfireBurningEffect());
        }
        Iterator<CampfireBurningEffect> i = this.fires.iterator();
        while (i.hasNext()) {
            CampfireBurningEffect fires = i.next();
            fires.update();
            if (!fires.isDone) continue;
            i.remove();
        }
    }

    public void reopen() {
        hidden = false;
        this.hideStuffTimer = 0.5f;
        this.somethingSelected = false;
    }

    public void render(SpriteBatch sb) {
        if (!hidden) {
            this.renderFire(sb);
            AbstractDungeon.player.render(sb);
            for (CampfireBubbleEffect e : this.bubbles) {
                e.render(sb, 950.0f * Settings.scale, 600.0f * Settings.scale + this.effect.y / 4.0f);
            }
            FontHelper.renderFontCentered(sb, FontHelper.bannerFont, this.bubbleMsg, 950.0f * Settings.scale, 850.0f * Settings.scale + this.effect.y / 3.0f, Settings.CREAM_COLOR);
            for (AbstractCampfireOption o : this.buttons) {
                o.render(sb);
            }
        }
    }

    private String getCampMessage() {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("What to do?");
        msgs.add("Hmm...");
        msgs.add("What shall I do?");
        msgs.add("Time for a break");
        if (this.buttons.size() > 2) {
            msgs.add("So many options...");
        }
        if (AbstractDungeon.player.currentHealth < AbstractDungeon.player.maxHealth / 2) {
            msgs.add("I should rest");
            msgs.add("So tired...");
        }
        return (String)msgs.get(MathUtils.random(msgs.size() - 1));
    }

    private void renderFire(SpriteBatch sb) {
        for (CampfireBurningEffect e : this.fires) {
            e.render(sb);
        }
    }
}

