/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.rooms;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.rewards.chests.AbstractChest;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.vfx.ChestShineEffect;
import com.megacrit.cardcrawl.vfx.scene.SpookyChestEffect;

public class TreasureRoom
extends AbstractRoom {
    public AbstractChest chest;
    private float shinyTimer = 0.0f;
    private static final float SHINY_INTERVAL = 0.2f;

    public TreasureRoom() {
        this.phase = AbstractRoom.RoomPhase.COMPLETE;
        this.description = "You come across a chest...";
        this.mapSymbol = "T";
        this.mapImg = ImageMaster.MAP_NODE_TREASURE;
        this.mapImgOutline = ImageMaster.MAP_NODE_TREASURE_OUTLINE;
    }

    @Override
    public void onPlayerEntry() {
        this.playBGM(null);
        this.chest = AbstractDungeon.getRandomChest();
        AbstractDungeon.overlayMenu.proceedButton.setLabel("Skip Chest");
    }

    @Override
    public AbstractCard.CardRarity getCardRarity(int roll) {
        int rareRate = AbstractDungeon.player.hasRelic("Nloth's Gift") ? 9 : 3;
        if (roll < rareRate) {
            if (AbstractDungeon.player.hasRelic("Nloth's Gift") && roll > 3) {
                AbstractDungeon.player.getRelic("Nloth's Gift").flash();
            }
            return AbstractCard.CardRarity.RARE;
        }
        if (roll < 40) {
            return AbstractCard.CardRarity.UNCOMMON;
        }
        return AbstractCard.CardRarity.COMMON;
    }

    @Override
    public void update() {
        super.update();
        if (this.chest != null) {
            this.chest.update();
        }
        this.updateShiny();
    }

    private void updateShiny() {
        if (!this.chest.isOpen) {
            this.shinyTimer -= Gdx.graphics.getDeltaTime();
            if (this.shinyTimer < 0.0f) {
                this.shinyTimer = 0.2f;
                AbstractDungeon.topLevelEffects.add(new ChestShineEffect());
                AbstractDungeon.effectList.add(new SpookyChestEffect());
                AbstractDungeon.effectList.add(new SpookyChestEffect());
            }
        }
    }

    @Override
    public void renderAboveTopPanel(SpriteBatch sb) {
        super.renderAboveTopPanel(sb);
    }

    @Override
    public void render(SpriteBatch sb) {
        if (this.chest != null) {
            this.chest.render(sb);
        }
        super.render(sb);
    }
}

